/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.Event;
import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;

public class ProgressUpdateEvent
extends Event {
    ProgressUpdateEvent(JSONObject jsonData) {
        super(jsonData);
    }

    @Override
    public EventBody getBody() {
        return new EventBody(this.jsonData.getJSONObject("body"));
    }

    public ProgressUpdateEvent setBody(EventBody body) {
        this.jsonData.put("body", body.jsonData);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProgressUpdateEvent other = (ProgressUpdateEvent)obj;
        if (!Objects.equals(this.getEvent(), other.getEvent())) {
            return false;
        }
        if (!Objects.equals(this.getBody(), other.getBody())) {
            return false;
        }
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        return this.getSeq() == other.getSeq();
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + Objects.hashCode(this.getEvent());
        hash = 59 * hash + Objects.hashCode(this.getBody());
        hash = 59 * hash + Objects.hashCode(this.getType());
        hash = 59 * hash + Integer.hashCode(this.getSeq());
        return hash;
    }

    public static ProgressUpdateEvent create(EventBody body, Integer seq) {
        JSONObject json = new JSONObject();
        json.put("event", "progressUpdate");
        json.put("body", body.jsonData);
        json.put("type", "event");
        json.put("seq", seq);
        return new ProgressUpdateEvent(json);
    }

    public static class EventBody
    extends JSONBase {
        EventBody(JSONObject jsonData) {
            super(jsonData);
        }

        public String getProgressId() {
            return this.jsonData.getString("progressId");
        }

        public EventBody setProgressId(String progressId) {
            this.jsonData.put("progressId", progressId);
            return this;
        }

        public String getMessage() {
            return this.jsonData.optString("message", null);
        }

        public EventBody setMessage(String message) {
            this.jsonData.putOpt("message", message);
            return this;
        }

        public Integer getPercentage() {
            return this.jsonData.has("percentage") ? Integer.valueOf(this.jsonData.getInt("percentage")) : null;
        }

        public EventBody setPercentage(Integer percentage) {
            this.jsonData.putOpt("percentage", percentage);
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EventBody other = (EventBody)obj;
            if (!Objects.equals(this.getProgressId(), other.getProgressId())) {
                return false;
            }
            if (!Objects.equals(this.getMessage(), other.getMessage())) {
                return false;
            }
            return Objects.equals(this.getPercentage(), other.getPercentage());
        }

        public int hashCode() {
            int hash = 7;
            hash = 29 * hash + Objects.hashCode(this.getProgressId());
            if (this.getMessage() != null) {
                hash = 29 * hash + Objects.hashCode(this.getMessage());
            }
            if (this.getPercentage() != null) {
                hash = 29 * hash + Integer.hashCode(this.getPercentage());
            }
            return hash;
        }

        public static EventBody create(String progressId) {
            JSONObject json = new JSONObject();
            json.put("progressId", progressId);
            return new EventBody(json);
        }
    }
}

