/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.Module;
import com.oracle.truffle.tools.dap.types.Response;
import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ModulesResponse
extends Response {
    ModulesResponse(JSONObject jsonData) {
        super(jsonData);
    }

    @Override
    public ResponseBody getBody() {
        return new ResponseBody(this.jsonData.getJSONObject("body"));
    }

    public ModulesResponse setBody(ResponseBody body) {
        this.jsonData.put("body", body.jsonData);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModulesResponse other = (ModulesResponse)obj;
        if (!Objects.equals(this.getBody(), other.getBody())) {
            return false;
        }
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        if (this.getRequestSeq() != other.getRequestSeq()) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        if (!Objects.equals(this.getCommand(), other.getCommand())) {
            return false;
        }
        if (!Objects.equals(this.getMessage(), other.getMessage())) {
            return false;
        }
        return this.getSeq() == other.getSeq();
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + Objects.hashCode(this.getBody());
        hash = 23 * hash + Objects.hashCode(this.getType());
        hash = 23 * hash + Integer.hashCode(this.getRequestSeq());
        hash = 23 * hash + Boolean.hashCode(this.isSuccess());
        hash = 23 * hash + Objects.hashCode(this.getCommand());
        if (this.getMessage() != null) {
            hash = 23 * hash + Objects.hashCode(this.getMessage());
        }
        hash = 23 * hash + Integer.hashCode(this.getSeq());
        return hash;
    }

    public static ModulesResponse create(ResponseBody body, Integer requestSeq, Boolean success, String command, Integer seq) {
        JSONObject json = new JSONObject();
        json.put("body", body.jsonData);
        json.put("type", "response");
        json.put("request_seq", requestSeq);
        json.put("success", success);
        json.put("command", command);
        json.put("seq", seq);
        return new ModulesResponse(json);
    }

    public static class ResponseBody
    extends JSONBase {
        ResponseBody(JSONObject jsonData) {
            super(jsonData);
        }

        public List<Module> getModules() {
            JSONArray json = this.jsonData.getJSONArray("modules");
            ArrayList<Module> list = new ArrayList<Module>(json.length());
            for (int i = 0; i < json.length(); ++i) {
                list.add(new Module(json.getJSONObject(i)));
            }
            return Collections.unmodifiableList(list);
        }

        public ResponseBody setModules(List<Module> modules) {
            JSONArray json = new JSONArray();
            for (Module module : modules) {
                json.put(module.jsonData);
            }
            this.jsonData.put("modules", json);
            return this;
        }

        public Integer getTotalModules() {
            return this.jsonData.has("totalModules") ? Integer.valueOf(this.jsonData.getInt("totalModules")) : null;
        }

        public ResponseBody setTotalModules(Integer totalModules) {
            this.jsonData.putOpt("totalModules", totalModules);
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResponseBody other = (ResponseBody)obj;
            if (!Objects.equals(this.getModules(), other.getModules())) {
                return false;
            }
            return Objects.equals(this.getTotalModules(), other.getTotalModules());
        }

        public int hashCode() {
            int hash = 3;
            hash = 43 * hash + Objects.hashCode(this.getModules());
            if (this.getTotalModules() != null) {
                hash = 43 * hash + Integer.hashCode(this.getTotalModules());
            }
            return hash;
        }

        public static ResponseBody create(List<Module> modules) {
            JSONObject json = new JSONObject();
            JSONArray modulesJsonArr = new JSONArray();
            for (Module module : modules) {
                modulesJsonArr.put(module.jsonData);
            }
            json.put("modules", modulesJsonArr);
            return new ResponseBody(json);
        }
    }
}

