/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.SuppressFBWarnings;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;

public class DisassembleArguments
extends JSONBase {
    DisassembleArguments(JSONObject jsonData) {
        super(jsonData);
    }

    public String getMemoryReference() {
        return this.jsonData.getString("memoryReference");
    }

    public DisassembleArguments setMemoryReference(String memoryReference) {
        this.jsonData.put("memoryReference", memoryReference);
        return this;
    }

    public Integer getOffset() {
        return this.jsonData.has("offset") ? Integer.valueOf(this.jsonData.getInt("offset")) : null;
    }

    public DisassembleArguments setOffset(Integer offset) {
        this.jsonData.putOpt("offset", offset);
        return this;
    }

    public Integer getInstructionOffset() {
        return this.jsonData.has("instructionOffset") ? Integer.valueOf(this.jsonData.getInt("instructionOffset")) : null;
    }

    public DisassembleArguments setInstructionOffset(Integer instructionOffset) {
        this.jsonData.putOpt("instructionOffset", instructionOffset);
        return this;
    }

    public int getInstructionCount() {
        return this.jsonData.getInt("instructionCount");
    }

    public DisassembleArguments setInstructionCount(int instructionCount) {
        this.jsonData.put("instructionCount", instructionCount);
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getResolveSymbols() {
        return this.jsonData.has("resolveSymbols") ? Boolean.valueOf(this.jsonData.getBoolean("resolveSymbols")) : null;
    }

    public DisassembleArguments setResolveSymbols(Boolean resolveSymbols) {
        this.jsonData.putOpt("resolveSymbols", resolveSymbols);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DisassembleArguments other = (DisassembleArguments)obj;
        if (!Objects.equals(this.getMemoryReference(), other.getMemoryReference())) {
            return false;
        }
        if (!Objects.equals(this.getOffset(), other.getOffset())) {
            return false;
        }
        if (!Objects.equals(this.getInstructionOffset(), other.getInstructionOffset())) {
            return false;
        }
        if (this.getInstructionCount() != other.getInstructionCount()) {
            return false;
        }
        return Objects.equals(this.getResolveSymbols(), other.getResolveSymbols());
    }

    public int hashCode() {
        int hash = 3;
        hash = 23 * hash + Objects.hashCode(this.getMemoryReference());
        if (this.getOffset() != null) {
            hash = 23 * hash + Integer.hashCode(this.getOffset());
        }
        if (this.getInstructionOffset() != null) {
            hash = 23 * hash + Integer.hashCode(this.getInstructionOffset());
        }
        hash = 23 * hash + Integer.hashCode(this.getInstructionCount());
        if (this.getResolveSymbols() != null) {
            hash = 23 * hash + Boolean.hashCode(this.getResolveSymbols());
        }
        return hash;
    }

    public static DisassembleArguments create(String memoryReference, Integer instructionCount) {
        JSONObject json = new JSONObject();
        json.put("memoryReference", memoryReference);
        json.put("instructionCount", instructionCount);
        return new DisassembleArguments(json);
    }
}

