/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.Event;
import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.SuppressFBWarnings;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;

public class ContinuedEvent
extends Event {
    ContinuedEvent(JSONObject jsonData) {
        super(jsonData);
    }

    @Override
    public EventBody getBody() {
        return new EventBody(this.jsonData.getJSONObject("body"));
    }

    public ContinuedEvent setBody(EventBody body) {
        this.jsonData.put("body", body.jsonData);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContinuedEvent other = (ContinuedEvent)obj;
        if (!Objects.equals(this.getEvent(), other.getEvent())) {
            return false;
        }
        if (!Objects.equals(this.getBody(), other.getBody())) {
            return false;
        }
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        return this.getSeq() == other.getSeq();
    }

    @Override
    public int hashCode() {
        int hash = 2;
        hash = 29 * hash + Objects.hashCode(this.getEvent());
        hash = 29 * hash + Objects.hashCode(this.getBody());
        hash = 29 * hash + Objects.hashCode(this.getType());
        hash = 29 * hash + Integer.hashCode(this.getSeq());
        return hash;
    }

    public static ContinuedEvent create(EventBody body, Integer seq) {
        JSONObject json = new JSONObject();
        json.put("event", "continued");
        json.put("body", body.jsonData);
        json.put("type", "event");
        json.put("seq", seq);
        return new ContinuedEvent(json);
    }

    public static class EventBody
    extends JSONBase {
        EventBody(JSONObject jsonData) {
            super(jsonData);
        }

        public int getThreadId() {
            return this.jsonData.getInt("threadId");
        }

        public EventBody setThreadId(int threadId) {
            this.jsonData.put("threadId", threadId);
            return this;
        }

        @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
        public Boolean getAllThreadsContinued() {
            return this.jsonData.has("allThreadsContinued") ? Boolean.valueOf(this.jsonData.getBoolean("allThreadsContinued")) : null;
        }

        public EventBody setAllThreadsContinued(Boolean allThreadsContinued) {
            this.jsonData.putOpt("allThreadsContinued", allThreadsContinued);
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EventBody other = (EventBody)obj;
            if (this.getThreadId() != other.getThreadId()) {
                return false;
            }
            return Objects.equals(this.getAllThreadsContinued(), other.getAllThreadsContinued());
        }

        public int hashCode() {
            int hash = 3;
            hash = 29 * hash + Integer.hashCode(this.getThreadId());
            if (this.getAllThreadsContinued() != null) {
                hash = 29 * hash + Boolean.hashCode(this.getAllThreadsContinued());
            }
            return hash;
        }

        public static EventBody create(Integer threadId) {
            JSONObject json = new JSONObject();
            json.put("threadId", threadId);
            return new EventBody(json);
        }
    }
}

