/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.server;

import com.oracle.truffle.api.debug.Breakpoint;
import com.oracle.truffle.api.debug.DebugStackFrame;
import com.oracle.truffle.api.debug.DebuggerSession;
import com.oracle.truffle.api.debug.SourceElement;
import com.oracle.truffle.api.instrumentation.LoadSourceSectionEvent;
import com.oracle.truffle.api.instrumentation.LoadSourceSectionListener;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.tools.dap.server.ExecutionContext;
import com.oracle.truffle.tools.dap.types.Breakpoint;
import com.oracle.truffle.tools.dap.types.BreakpointEvent;
import com.oracle.truffle.tools.dap.types.BreakpointLocation;
import com.oracle.truffle.tools.dap.types.BreakpointLocationsArguments;
import com.oracle.truffle.tools.dap.types.DebugProtocolClient;
import com.oracle.truffle.tools.dap.types.FunctionBreakpoint;
import com.oracle.truffle.tools.dap.types.SetBreakpointsArguments;
import com.oracle.truffle.tools.dap.types.SetFunctionBreakpointsArguments;
import com.oracle.truffle.tools.dap.types.SourceBreakpoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class BreakpointsHandler {
    private static final Set<Class<? extends Tag>> SUSPENDABLE_TAGS_SET = Collections.singleton(StandardTags.StatementTag.class);
    private static final Class<?>[] SUSPENDABLE_TAGS = SUSPENDABLE_TAGS_SET.toArray(new Class[SUSPENDABLE_TAGS_SET.size()]);
    private static final Pattern HITCONDITION_REGEXP = Pattern.compile("^(>|>=|=|<|<=|%)?\\s*([0-9]+)$");
    private final ExecutionContext context;
    private final DebuggerSession debuggerSession;
    private final ResolvedHandler resolvedHandler = new ResolvedHandler();
    private final Map<String, Map<SourceBreakpoint, Integer>> sourceBreakpoints = new HashMap<String, Map<SourceBreakpoint, Integer>>();
    private final AtomicReference<Map<FunctionBreakpoint, Integer>> functionBreakpoints = new AtomicReference();
    private final Map<com.oracle.truffle.api.debug.Breakpoint, Integer> bp2IDs = new HashMap<com.oracle.truffle.api.debug.Breakpoint, Integer>();
    private final Map<Integer, com.oracle.truffle.api.debug.Breakpoint> id2Bps = new HashMap<Integer, com.oracle.truffle.api.debug.Breakpoint>();
    private final Map<com.oracle.truffle.api.debug.Breakpoint, String> logMessages = new HashMap<com.oracle.truffle.api.debug.Breakpoint, String>();
    private final Map<com.oracle.truffle.api.debug.Breakpoint, String[]> hitConditions = new HashMap<com.oracle.truffle.api.debug.Breakpoint, String[]>();
    private final Map<com.oracle.truffle.api.debug.Breakpoint, String> functionNames = new HashMap<com.oracle.truffle.api.debug.Breakpoint, String>();
    private final Map<com.oracle.truffle.api.debug.Breakpoint, SourceSection> resolvedBreakpoints = new HashMap<com.oracle.truffle.api.debug.Breakpoint, SourceSection>();
    private final AtomicReference<com.oracle.truffle.api.debug.Breakpoint> exceptionBreakpoint = new AtomicReference();
    private int lastId = 0;

    public BreakpointsHandler(ExecutionContext context, DebuggerSession debuggerSession) {
        this.context = context;
        this.debuggerSession = debuggerSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Breakpoint> setBreakpoints(SetBreakpointsArguments args) {
        Map toRemove;
        String srcId;
        Source source;
        Integer sourceReference = args.getSource().getSourceReference();
        String path = args.getSource().getPath();
        if (sourceReference != null && sourceReference > 0) {
            source = this.context.getLoadedSourcesHandler().getSource(sourceReference);
            srcId = (path != null ? path : "") + '#' + sourceReference;
        } else {
            source = this.context.getLoadedSourcesHandler().getSource(path);
            srcId = path;
        }
        HashMap<SourceBreakpoint, Object> toAdd = new HashMap<SourceBreakpoint, Object>();
        Map<com.oracle.truffle.api.debug.Breakpoint, Integer> map = this.bp2IDs;
        synchronized (map) {
            toRemove = this.sourceBreakpoints.put(srcId, toAdd);
        }
        ArrayList<Breakpoint> breakpoints = new ArrayList<Breakpoint>(args.getBreakpoints().size());
        if (source != null) {
            com.oracle.truffle.api.debug.Breakpoint bp;
            Object id;
            for (SourceBreakpoint sourceBreakpoint : args.getBreakpoints()) {
                SourceSection section;
                Object builder;
                String message = null;
                Map<com.oracle.truffle.api.debug.Breakpoint, Integer> map2 = this.bp2IDs;
                synchronized (map2) {
                    id = toRemove != null ? (Integer)toRemove.remove(sourceBreakpoint) : null;
                }
                if (id == null) {
                    Object matcher;
                    String trimmedHitCondition;
                    builder = com.oracle.truffle.api.debug.Breakpoint.newBuilder((Source)source).lineIs(this.context.clientToDebuggerLine(sourceBreakpoint.getLine()));
                    if (sourceBreakpoint.getColumn() != null) {
                        builder.columnIs(this.context.clientToDebuggerColumn(sourceBreakpoint.getColumn()));
                    }
                    bp = builder.resolveListener((Breakpoint.ResolveListener)this.resolvedHandler).build();
                    if (sourceBreakpoint.getCondition() != null && !sourceBreakpoint.getCondition().isEmpty()) {
                        bp.setCondition(sourceBreakpoint.getCondition());
                    }
                    String[] hitCondition = null;
                    if (sourceBreakpoint.getHitCondition() != null && !(trimmedHitCondition = sourceBreakpoint.getHitCondition().trim()).isEmpty()) {
                        matcher = HITCONDITION_REGEXP.matcher(trimmedHitCondition);
                        if (((Matcher)matcher).matches() && ((Matcher)matcher).groupCount() == 2) {
                            if (((Matcher)matcher).group(0) == null) {
                                builder.ignoreCount(Integer.parseInt(((Matcher)matcher).group(2)));
                            } else {
                                hitCondition = new String[]{((Matcher)matcher).group(1), ((Matcher)matcher).group(2)};
                            }
                        } else {
                            message = "Invalid hit condition: " + trimmedHitCondition;
                        }
                    }
                    bp = this.debuggerSession.install(bp);
                    String logMessage = sourceBreakpoint.getLogMessage() != null ? sourceBreakpoint.getLogMessage().trim() : "";
                    matcher = this.bp2IDs;
                    synchronized (matcher) {
                        id = ++this.lastId;
                        this.bp2IDs.put(bp, (Integer)id);
                        this.id2Bps.put((Integer)id, bp);
                        if (!logMessage.isEmpty()) {
                            this.logMessages.put(bp, logMessage);
                        }
                        if (hitCondition != null) {
                            this.hitConditions.put(bp, hitCondition);
                        }
                    }
                } else {
                    bp = this.id2Bps.get(id);
                }
                builder = this.bp2IDs;
                synchronized (builder) {
                    toAdd.put(sourceBreakpoint, id);
                    section = this.resolvedBreakpoints.get(bp);
                }
                if (section != null) {
                    breakpoints.add(Breakpoint.create(message == null).setId((Integer)id).setMessage(message).setLine(this.context.debuggerToClientLine(section.getStartLine())).setColumn(this.context.debuggerToClientColumn(section.getStartColumn())).setEndLine(this.context.debuggerToClientLine(section.getEndLine())).setEndColumn(this.context.debuggerToClientColumn(section.getEndColumn())));
                    continue;
                }
                breakpoints.add(Breakpoint.create(false).setId((Integer)id).setMessage(message).setLine(sourceBreakpoint.getLine()).setColumn(sourceBreakpoint.getColumn()));
            }
            if (toRemove != null) {
                for (Integer id2 : toRemove.values()) {
                    id = this.bp2IDs;
                    synchronized (id) {
                        bp = this.id2Bps.remove(id2);
                        if (bp != null) {
                            bp.dispose();
                            this.bp2IDs.remove(bp);
                            this.logMessages.remove(bp);
                            this.hitConditions.remove(bp);
                            this.resolvedBreakpoints.remove(bp);
                        }
                    }
                }
            }
        } else {
            this.context.getLoadedSourcesHandler().runOnLoad(args.getSource().getPath(), null);
            ArrayList<Consumer<Source>> tasks = new ArrayList<Consumer<Source>>(args.getBreakpoints().size());
            for (SourceBreakpoint sourceBreakpoint : args.getBreakpoints()) {
                Map<com.oracle.truffle.api.debug.Breakpoint, Integer> map3 = this.bp2IDs;
                synchronized (map3) {
                    String trimmedHitCondition;
                    Integer id;
                    Integer n = id = toRemove != null ? (Integer)toRemove.remove(sourceBreakpoint) : null;
                    if (id == null) {
                        id = ++this.lastId;
                        toAdd.put(sourceBreakpoint, id);
                    }
                    Integer finalId = id;
                    String logMessage = sourceBreakpoint.getLogMessage() != null ? sourceBreakpoint.getLogMessage().trim() : "";
                    String[] hitCondition = null;
                    String message = null;
                    if (sourceBreakpoint.getHitCondition() != null && !(trimmedHitCondition = sourceBreakpoint.getHitCondition().trim()).isEmpty()) {
                        Matcher matcher = HITCONDITION_REGEXP.matcher(trimmedHitCondition);
                        if (matcher.matches() && matcher.groupCount() == 2) {
                            hitCondition = new String[]{matcher.group(1), matcher.group(2)};
                        } else {
                            message = "Invalid hit condition: " + trimmedHitCondition;
                        }
                    }
                    String[] finalHitCondition = hitCondition;
                    String finalMessage = message;
                    tasks.add(src -> {
                        DebugProtocolClient client;
                        SourceSection section;
                        Breakpoint.Builder builder = com.oracle.truffle.api.debug.Breakpoint.newBuilder((Source)src).lineIs(this.context.clientToDebuggerLine(sourceBreakpoint.getLine()));
                        if (sourceBreakpoint.getColumn() != null) {
                            builder.columnIs(this.context.clientToDebuggerColumn(sourceBreakpoint.getColumn()));
                        }
                        com.oracle.truffle.api.debug.Breakpoint bp = builder.resolveListener((Breakpoint.ResolveListener)this.resolvedHandler).build();
                        if (sourceBreakpoint.getCondition() != null && !sourceBreakpoint.getCondition().isEmpty()) {
                            bp.setCondition(sourceBreakpoint.getCondition());
                        }
                        bp = this.debuggerSession.install(bp);
                        Map<com.oracle.truffle.api.debug.Breakpoint, Integer> map = this.bp2IDs;
                        synchronized (map) {
                            this.bp2IDs.put(bp, finalId);
                            this.id2Bps.put(finalId, bp);
                            if (!logMessage.isEmpty()) {
                                this.logMessages.put(bp, logMessage);
                            }
                            if (finalHitCondition != null) {
                                this.hitConditions.put(bp, finalHitCondition);
                            }
                            section = this.resolvedBreakpoints.get(bp);
                        }
                        if (section != null && (client = this.context.getClient()) != null) {
                            client.breakpoint(BreakpointEvent.EventBody.create("changed", Breakpoint.create(finalMessage == null).setId(finalId).setMessage(finalMessage).setLine(this.context.debuggerToClientLine(section.getStartLine())).setColumn(this.context.debuggerToClientColumn(section.getStartColumn())).setEndLine(this.context.debuggerToClientLine(section.getEndLine())).setEndColumn(this.context.debuggerToClientColumn(section.getEndColumn()))));
                        }
                    });
                    breakpoints.add(Breakpoint.create(false).setId(id).setMessage(finalMessage).setLine(sourceBreakpoint.getLine()).setColumn(sourceBreakpoint.getColumn()));
                }
            }
            if (!tasks.isEmpty()) {
                this.context.getLoadedSourcesHandler().runOnLoad(args.getSource().getPath(), src -> {
                    for (Consumer task : tasks) {
                        task.accept(src);
                    }
                });
            }
        }
        return breakpoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Breakpoint> setFunctionBreakpoints(SetFunctionBreakpointsArguments args) {
        com.oracle.truffle.api.debug.Breakpoint bp;
        HashMap<FunctionBreakpoint, Integer> toAdd = new HashMap<FunctionBreakpoint, Integer>();
        Map toRemove = this.functionBreakpoints.getAndSet(toAdd);
        ArrayList<Breakpoint> breakpoints = new ArrayList<Breakpoint>(args.getBreakpoints().size());
        for (FunctionBreakpoint functionBreakpoint : args.getBreakpoints()) {
            SourceSection section;
            Integer id;
            String message = null;
            Map<com.oracle.truffle.api.debug.Breakpoint, Integer> map = this.bp2IDs;
            synchronized (map) {
                id = toRemove != null ? (Integer)toRemove.remove(functionBreakpoint) : null;
            }
            if (id == null) {
                String trimmedHitCondition;
                Breakpoint.Builder builder = com.oracle.truffle.api.debug.Breakpoint.newBuilder((Source)null).sourceElements(new SourceElement[]{SourceElement.ROOT});
                bp = builder.resolveListener((Breakpoint.ResolveListener)this.resolvedHandler).build();
                if (functionBreakpoint.getCondition() != null && !functionBreakpoint.getCondition().isEmpty()) {
                    bp.setCondition(functionBreakpoint.getCondition());
                }
                String[] hitCondition = null;
                if (functionBreakpoint.getHitCondition() != null && !(trimmedHitCondition = functionBreakpoint.getHitCondition().trim()).isEmpty()) {
                    Matcher matcher = HITCONDITION_REGEXP.matcher(trimmedHitCondition);
                    if (matcher.matches() && matcher.groupCount() == 2) {
                        if (matcher.group(0) == null) {
                            builder.ignoreCount(Integer.parseInt(matcher.group(2)));
                        } else {
                            hitCondition = new String[]{matcher.group(1), matcher.group(2)};
                        }
                    } else {
                        message = "Invalid hit condition: " + trimmedHitCondition;
                    }
                }
                bp = this.debuggerSession.install(bp);
                Map<com.oracle.truffle.api.debug.Breakpoint, Integer> map2 = this.bp2IDs;
                synchronized (map2) {
                    id = ++this.lastId;
                    this.bp2IDs.put(bp, id);
                    this.id2Bps.put(id, bp);
                    if (hitCondition != null) {
                        this.hitConditions.put(bp, hitCondition);
                    }
                    this.functionNames.put(bp, functionBreakpoint.getName());
                }
            } else {
                bp = this.id2Bps.get(id);
            }
            map = this.bp2IDs;
            synchronized (map) {
                toAdd.put(functionBreakpoint, id);
                section = this.resolvedBreakpoints.get(bp);
            }
            if (section != null) {
                breakpoints.add(Breakpoint.create(message == null).setId(id).setMessage(message).setLine(this.context.debuggerToClientLine(section.getStartLine())).setColumn(this.context.debuggerToClientColumn(section.getStartColumn())).setEndLine(this.context.debuggerToClientLine(section.getEndLine())).setEndColumn(this.context.debuggerToClientColumn(section.getEndColumn())));
                continue;
            }
            breakpoints.add(Breakpoint.create(false).setId(id).setMessage(message));
        }
        if (toRemove != null) {
            for (Integer id : toRemove.values()) {
                Map<com.oracle.truffle.api.debug.Breakpoint, Integer> map = this.bp2IDs;
                synchronized (map) {
                    bp = this.id2Bps.remove(id);
                    if (bp != null) {
                        bp.dispose();
                        this.bp2IDs.remove(bp);
                        this.logMessages.remove(bp);
                        this.hitConditions.remove(bp);
                        this.resolvedBreakpoints.remove(bp);
                        this.functionNames.remove(bp);
                    }
                }
            }
        }
        return breakpoints;
    }

    public void setExceptionBreakpoint(boolean caught, boolean uncaught) {
        com.oracle.truffle.api.debug.Breakpoint oldBp;
        com.oracle.truffle.api.debug.Breakpoint newBp = null;
        if (caught || uncaught) {
            newBp = com.oracle.truffle.api.debug.Breakpoint.newExceptionBuilder((boolean)caught, (boolean)uncaught).build();
            this.debuggerSession.install(newBp);
        }
        if ((oldBp = this.exceptionBreakpoint.getAndSet(newBp)) != null) {
            oldBp.dispose();
        }
    }

    public List<BreakpointLocation> breakpointLocations(BreakpointLocationsArguments args) {
        Integer sourceReference = args.getSource().getSourceReference();
        Source source = sourceReference != null && sourceReference > 0 ? this.context.getLoadedSourcesHandler().getSource(sourceReference) : this.context.getLoadedSourcesHandler().getSource(args.getSource().getPath());
        ArrayList<BreakpointLocation> locations = new ArrayList<BreakpointLocation>();
        if (source != null && source.hasCharacters() && source.getLength() > 0) {
            int c2;
            int l2;
            int c1;
            int lc = source.getLineCount();
            int l1 = this.context.clientToDebuggerLine(args.getLine());
            int n = c1 = args.getColumn() != null ? this.context.clientToDebuggerColumn(args.getColumn()) : 0;
            if (c1 <= 0) {
                c1 = 1;
            }
            if (l1 > lc) {
                l1 = lc;
                c1 = source.getLineLength(l1);
            }
            if (args.getEndLine() != null) {
                l2 = this.context.clientToDebuggerLine(args.getEndLine());
                int n2 = c2 = args.getEndColumn() != null ? this.context.clientToDebuggerColumn(args.getEndColumn()) : source.getLineLength(l2);
                if (l1 != l2 || c1 != c2) {
                    if (l2 > lc) {
                        l2 = lc;
                        c2 = source.getLineLength(l2);
                    } else if (c2 <= 1) {
                        if (--l2 <= 0) {
                            l2 = 1;
                        }
                        c2 = source.getLineLength(l2);
                    } else {
                        --c2;
                    }
                    if (l1 > l2) {
                        l1 = l2;
                    }
                }
            } else {
                l2 = l1;
                c2 = source.getLineLength(l2);
            }
            if (c2 == 0) {
                c2 = 1;
            }
            if (l1 == l2 && c2 < c1) {
                c1 = c2;
            }
            SourceSection range = source.createSection(l1, c1, l2, c2);
            for (SourceSection ss : this.findSuspendableLocations(range)) {
                locations.add(BreakpointLocation.create(this.context.debuggerToClientLine(ss.getStartLine())).setColumn(this.context.debuggerToClientColumn(ss.getStartColumn())));
            }
        }
        return locations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLogMessage(com.oracle.truffle.api.debug.Breakpoint bp) {
        Map<com.oracle.truffle.api.debug.Breakpoint, Integer> map = this.bp2IDs;
        synchronized (map) {
            return this.logMessages.get(bp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkConditions(com.oracle.truffle.api.debug.Breakpoint bp, DebugStackFrame topStackFrame) {
        String[] hitCondition;
        String functionName;
        Map<com.oracle.truffle.api.debug.Breakpoint, Integer> map = this.bp2IDs;
        synchronized (map) {
            functionName = this.functionNames.get(bp);
            hitCondition = this.hitConditions.get(bp);
        }
        if (functionName != null && !functionName.equals(topStackFrame.getName())) {
            return false;
        }
        if (hitCondition != null) {
            int count = bp.getHitCount();
            int value = Integer.parseInt(hitCondition[1]);
            switch (hitCondition[0]) {
                case ">": {
                    return count > value;
                }
                case ">=": {
                    return count >= value;
                }
                case "=": {
                    return count == value;
                }
                case "<": {
                    return count < value;
                }
                case "<=": {
                    return count <= value;
                }
                case "%": {
                    return count % value == 0;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<SourceSection> findSuspendableLocations(SourceSection range) {
        int endIndex;
        int startIndex;
        Source source = range.getSource();
        SectionsCollector sectionsCollector = this.collectSuspendableLocations(source, startIndex = range.getCharIndex(), endIndex = range.getCharEndIndex());
        List<SourceSection> sections = sectionsCollector.getSections();
        if (sections.isEmpty()) {
            final AtomicReference nearestSection = new AtomicReference();
            com.oracle.truffle.api.debug.Breakpoint breakpoint = com.oracle.truffle.api.debug.Breakpoint.newBuilder((Source)source).ignoreCount(Integer.MAX_VALUE).lineIs(range.getStartLine()).columnIs(range.getStartColumn()).resolveListener(new Breakpoint.ResolveListener(){

                public void breakpointResolved(com.oracle.truffle.api.debug.Breakpoint b, SourceSection section) {
                    nearestSection.set(section);
                }
            }).build();
            try {
                this.debuggerSession.install(breakpoint);
            }
            finally {
                breakpoint.dispose();
            }
            SourceSection suspendableSection = (SourceSection)nearestSection.get();
            if (suspendableSection != null) {
                startIndex = suspendableSection.getCharIndex();
                endIndex = suspendableSection.getCharEndIndex();
                sectionsCollector = this.collectSuspendableLocations(source, startIndex, endIndex);
                sections = sectionsCollector.getSections();
            }
        }
        return sections;
    }

    private SectionsCollector collectSuspendableLocations(Source source, int startIndex, int endIndex) {
        SourceSectionFilter filter = SourceSectionFilter.newBuilder().sourceIs(new Source[]{source}).indexIn(new SourceSectionFilter.IndexRange[]{SourceSectionFilter.IndexRange.between((int)startIndex, (int)endIndex)}).tagIs((Class[])SUSPENDABLE_TAGS).build();
        SectionsCollector sectionsCollector = new SectionsCollector(startIndex);
        this.context.getEnv().getInstrumenter().visitLoadedSourceSections(filter, (LoadSourceSectionListener)sectionsCollector);
        return sectionsCollector;
    }

    private static final class SectionsCollector
    implements LoadSourceSectionListener {
        protected final int startIndex;
        private final List<SourceSection> sections = new ArrayList<SourceSection>();

        SectionsCollector(int startIndex) {
            this.startIndex = startIndex;
        }

        public void onLoad(LoadSourceSectionEvent event) {
            SourceSection section = event.getSourceSection();
            if (section.getCharIndex() >= this.startIndex) {
                this.sections.add(section);
            }
        }

        List<SourceSection> getSections() {
            return this.sections;
        }
    }

    private final class ResolvedHandler
    implements Breakpoint.ResolveListener {
        private ResolvedHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void breakpointResolved(com.oracle.truffle.api.debug.Breakpoint breakpoint, SourceSection section) {
            Integer breakpointId;
            Map map = BreakpointsHandler.this.bp2IDs;
            synchronized (map) {
                BreakpointsHandler.this.resolvedBreakpoints.put(breakpoint, section);
                breakpointId = (Integer)BreakpointsHandler.this.bp2IDs.get(breakpoint);
                if (breakpointId == null) {
                    return;
                }
            }
            DebugProtocolClient client = BreakpointsHandler.this.context.getClient();
            if (client != null) {
                client.breakpoint(BreakpointEvent.EventBody.create("changed", Breakpoint.create(true).setId(breakpointId).setLine(BreakpointsHandler.this.context.debuggerToClientLine(section.getStartLine())).setColumn(BreakpointsHandler.this.context.debuggerToClientColumn(section.getStartColumn())).setEndLine(BreakpointsHandler.this.context.debuggerToClientLine(section.getEndLine())).setEndColumn(BreakpointsHandler.this.context.debuggerToClientColumn(section.getEndColumn()))));
            }
        }
    }
}

