/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.instrument;

import com.oracle.truffle.api.Option;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.tools.dap.instrument.DAPIOException;
import com.oracle.truffle.tools.dap.instrument.DAPInstrumentOptionDescriptors;
import com.oracle.truffle.tools.dap.server.DebugProtocolServerImpl;
import com.oracle.truffle.tools.dap.server.ExecutionContext;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.concurrent.CompletableFuture;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionStability;
import org.graalvm.options.OptionType;
import org.graalvm.options.OptionValues;

@TruffleInstrument.Registration(id="dap", name="Debug Protocol Server", version="0.1")
public final class DAPInstrument
extends TruffleInstrument {
    public static final String ID = "dap";
    private static final int DEFAULT_PORT = 4711;
    private static final HostAndPort DEFAULT_ADDRESS = new HostAndPort(null, 4711);
    private OptionValues options;
    private volatile boolean waitForClose = false;
    static final OptionType<HostAndPort> ADDRESS_OR_BOOLEAN = new OptionType("[[host:]port]", address -> {
        if (address.isEmpty() || address.equals("true")) {
            return DEFAULT_ADDRESS;
        }
        return HostAndPort.parse(address);
    }, address -> address.verify());
    @Option(name="", help="Start the Debug Protocol Server on [[host:]port]. (default: <loopback address>:4711)", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<HostAndPort> Dap = new OptionKey((Object)DEFAULT_ADDRESS, ADDRESS_OR_BOOLEAN);
    @Option(help="Suspend the execution at first executed source line. (default:true)", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<Boolean> Suspend = new OptionKey((Object)true);
    @Option(help="Do not execute any source code until debugger client is attached. (default:false)", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<Boolean> WaitAttached = new OptionKey((Object)false);
    @Option(help="Debug internal sources. (default:false)", category=OptionCategory.INTERNAL)
    static final OptionKey<Boolean> Internal = new OptionKey((Object)false);
    @Option(help="Debug language initialization. (default:false)", category=OptionCategory.INTERNAL)
    static final OptionKey<Boolean> Initialization = new OptionKey((Object)false);
    @Option(help="Requested maximum length of the Socket queue of incoming connections. (default: -1)", category=OptionCategory.EXPERT)
    static final OptionKey<Integer> SocketBacklogSize = new OptionKey((Object)-1);

    protected void onCreate(TruffleInstrument.Env env) {
        this.options = env.getOptions();
        if (this.options.hasSetOptions()) {
            this.launchServer(env, new PrintWriter(env.out(), true), new PrintWriter(env.err(), true));
        }
    }

    protected void onFinalize(TruffleInstrument.Env env) {
        if (this.waitForClose) {
            PrintWriter info = new PrintWriter(env.out());
            info.println("Waiting for the debugger client to disconnect...");
            info.flush();
            this.waitForClose();
        }
    }

    protected OptionDescriptors getOptionDescriptors() {
        return new DAPInstrumentOptionDescriptors();
    }

    private synchronized void setWaitForClose() {
        this.waitForClose = true;
    }

    public synchronized void waitForClose() {
        while (this.waitForClose) {
            try {
                ((Object)((Object)this)).wait();
            }
            catch (InterruptedException ex) {
                break;
            }
        }
    }

    private synchronized void notifyClose() {
        this.waitForClose = false;
        ((Object)((Object)this)).notifyAll();
    }

    private void launchServer(TruffleInstrument.Env env, PrintWriter info, PrintWriter err) {
        assert (this.options != null);
        assert (this.options.hasSetOptions());
        HostAndPort hostAndPort = (HostAndPort)this.options.get(Dap);
        try {
            InetSocketAddress socketAddress = hostAndPort.createSocket();
            int port = socketAddress.getPort();
            ExecutionContext context = new ExecutionContext(env, info, err, (Boolean)this.options.get(Internal), (Boolean)this.options.get(Initialization));
            ServerSocket serverSocket = new ServerSocket(port, (Integer)this.options.get(SocketBacklogSize), socketAddress.getAddress());
            ((CompletableFuture)DebugProtocolServerImpl.create(context, (Boolean)this.options.get(Suspend), (Boolean)this.options.get(WaitAttached), (Boolean)this.options.get(Initialization)).start(serverSocket, () -> this.setWaitForClose()).thenRun(() -> this.notifyClose())).exceptionally(throwable -> {
                throwable.printStackTrace(err);
                this.notifyClose();
                return null;
            });
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable e) {
            String message = String.format("[Graal DAP] Starting server on %s failed: %s", hostAndPort.getHostPort(), e.getLocalizedMessage());
            new DAPIOException(message, e).printStackTrace(err);
        }
    }

    static final class HostAndPort {
        private final String host;
        private String portStr;
        private int port;
        private InetAddress inetAddress;

        private HostAndPort(String host, int port) {
            this.host = host;
            this.port = port;
        }

        private HostAndPort(String host, String portStr) {
            this.host = host;
            this.portStr = portStr;
        }

        static HostAndPort parse(String address) {
            String host;
            String port;
            int colon = address.indexOf(58);
            if (colon >= 0) {
                port = address.substring(colon + 1);
                host = address.substring(0, colon);
            } else {
                try {
                    Integer.parseInt(address);
                    port = address;
                    host = null;
                }
                catch (NumberFormatException e) {
                    port = Integer.toString(4711);
                    host = address;
                }
            }
            return new HostAndPort(host, port);
        }

        void verify() {
            if (this.port == 0) {
                try {
                    this.port = Integer.parseInt(this.portStr);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Port is not a number: " + this.portStr);
                }
            }
            if (this.port != 0 && (this.port < 1024 || 65535 < this.port)) {
                throw new IllegalArgumentException("Invalid port number: " + this.port + ". Needs to be 0, or in range from 1024 to 65535.");
            }
            if (this.host != null && !this.host.isEmpty()) {
                try {
                    this.inetAddress = InetAddress.getByName(this.host);
                }
                catch (UnknownHostException ex) {
                    throw new IllegalArgumentException(ex.getLocalizedMessage(), ex);
                }
            }
        }

        String getHostPort() {
            String hostName = this.host;
            if (hostName == null || hostName.isEmpty()) {
                hostName = this.inetAddress != null ? this.inetAddress.toString() : InetAddress.getLoopbackAddress().toString();
            }
            return hostName + ":" + this.port;
        }

        InetSocketAddress createSocket() {
            InetAddress ia = this.inetAddress == null ? InetAddress.getLoopbackAddress() : this.inetAddress;
            return new InetSocketAddress(ia, this.port);
        }
    }
}

