/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.serviceprovider.processor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.graalvm.compiler.processor.AbstractProcessor;

@SupportedAnnotationTypes(value={"org.graalvm.compiler.serviceprovider.ServiceProvider"})
public class ServiceProviderProcessor
extends AbstractProcessor {
    private static final String SERVICE_PROVIDER_CLASS_NAME = "org.graalvm.compiler.serviceprovider.ServiceProvider";
    private final Set<TypeElement> processed = new HashSet<TypeElement>();
    private final Map<TypeElement, String> serviceProviders = new HashMap<TypeElement, String>();

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    private boolean verifyAnnotation(TypeMirror serviceInterface, TypeElement serviceProvider) {
        if (!this.processingEnv.getTypeUtils().isSubtype(serviceProvider.asType(), serviceInterface)) {
            String msg = String.format("Service provider class %s must implement service interface %s", serviceProvider.getSimpleName(), serviceInterface);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, serviceProvider);
            return false;
        }
        return true;
    }

    private void processElement(TypeElement serviceProvider) {
        TypeMirror service;
        if (this.processed.contains(serviceProvider)) {
            return;
        }
        this.processed.add(serviceProvider);
        AnnotationMirror annotation = this.getAnnotation(serviceProvider, this.getType(SERVICE_PROVIDER_CLASS_NAME));
        if (annotation != null && this.verifyAnnotation(service = ServiceProviderProcessor.getAnnotationValue(annotation, "value", TypeMirror.class), serviceProvider)) {
            if (serviceProvider.getNestingKind().isNested()) {
                String msg = String.format("Service provider class %s must be a top level class", serviceProvider.getSimpleName());
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, serviceProvider);
            } else {
                TypeElement serviceElement = (TypeElement)this.processingEnv.getTypeUtils().asElement(service);
                String serviceName = serviceElement.getSimpleName().toString();
                for (Element enclosing = serviceElement.getEnclosingElement(); enclosing != null; enclosing = enclosing.getEnclosingElement()) {
                    ElementKind kind = enclosing.getKind();
                    if (kind == ElementKind.PACKAGE) {
                        serviceName = ((PackageElement)enclosing).getQualifiedName().toString() + "." + serviceName;
                        break;
                    }
                    if (kind == ElementKind.CLASS || kind == ElementKind.INTERFACE) {
                        serviceName = ((TypeElement)enclosing).getSimpleName().toString() + "$" + serviceName;
                        continue;
                    }
                    String msg = String.format("Cannot generate provider descriptor for service class %s as it is not nested in a package, class or interface", serviceElement.getQualifiedName());
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, serviceProvider);
                    return;
                }
                this.serviceProviders.put(serviceProvider, serviceName);
            }
        }
    }

    @Override
    public boolean doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            for (Map.Entry<TypeElement, String> e : this.serviceProviders.entrySet()) {
                this.createProviderFile(e.getKey().getQualifiedName().toString(), e.getValue(), e.getKey());
            }
            this.serviceProviders.clear();
            return true;
        }
        TypeElement serviceProviderTypeElement = this.getTypeElement(SERVICE_PROVIDER_CLASS_NAME);
        for (Element element : roundEnv.getElementsAnnotatedWith(serviceProviderTypeElement)) {
            assert (element.getKind().isClass());
            this.processElement((TypeElement)element);
        }
        return true;
    }
}

