/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.config;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.configure.ConfigurationFiles;
import com.oracle.svm.core.configure.ConfigurationParser;
import com.oracle.svm.core.configure.ReflectionConfigurationParser;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.OptionUtils;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.json.JSONParserException;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.config.ReflectionRegistryAdapter;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.graalvm.nativeimage.impl.ReflectionRegistry;

public final class ConfigurationParserUtils {
    public static ReflectionConfigurationParser<Class<?>> create(ReflectionRegistry registry, ImageClassLoader imageClassLoader) {
        return new ReflectionConfigurationParser(new ReflectionRegistryAdapter(registry, imageClassLoader), NativeImageOptions.AllowIncompleteClasspath.getValue());
    }

    public static int parseAndRegisterConfigurations(ConfigurationParser parser, ImageClassLoader classLoader, String featureName, HostedOptionKey<String[]> configFilesOption, HostedOptionKey<String[]> configResourcesOption, String directoryFileName) {
        int parsedCount = 0;
        Stream<Path> files = Stream.concat(OptionUtils.flatten(",", configFilesOption.getValue()).stream().map(x$0 -> Paths.get(x$0, new String[0])), ConfigurationFiles.findConfigurationFiles(directoryFileName).stream());
        parsedCount += files.map(Path::toAbsolutePath).mapToInt(path -> {
            int n;
            if (!Files.exists(path, new LinkOption[0])) {
                throw UserError.abort("The %s configuration file \"%s\" does not exist.", featureName, path);
            }
            FileReader reader = new FileReader(path.toFile());
            try {
                ConfigurationParserUtils.doParseAndRegister(parser, reader, featureName, path, configFilesOption);
                n = 1;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw UserError.abort("Could not open %s: %s", path, e.getMessage());
                }
            }
            ((Reader)reader).close();
            return n;
        }).sum();
        Stream configResourcesFromOption = OptionUtils.flatten(",", configResourcesOption.getValue()).stream().flatMap(s -> {
            Enumeration<URL> urls;
            try {
                urls = classLoader.findResourcesByName((String)s);
            }
            catch (IOException e) {
                throw UserError.abort(e, "Error while looking for %s in %s", s, classLoader);
            }
            if (!urls.hasMoreElements()) {
                throw UserError.abort("Could not find %s configuration resource \"%s\".", featureName, s);
            }
            return StreamSupport.stream(new Spliterators.AbstractSpliterator<URL>(Long.MAX_VALUE, 16){

                @Override
                public boolean tryAdvance(Consumer<? super URL> action) {
                    if (!urls.hasMoreElements()) {
                        return false;
                    }
                    action.accept((URL)urls.nextElement());
                    return true;
                }
            }, false);
        });
        Stream resources = Stream.concat(configResourcesFromOption, ConfigurationFiles.findConfigurationResources(directoryFileName, classLoader.getClassLoader()).stream());
        return parsedCount += resources.mapToInt(url -> {
            int n;
            URLConnection urlConnection = url.openConnection();
            urlConnection.setUseCaches(false);
            InputStreamReader reader = new InputStreamReader(urlConnection.getInputStream());
            try {
                ConfigurationParserUtils.doParseAndRegister(parser, reader, featureName, url, configResourcesOption);
                n = 1;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw UserError.abort("Could not open %s: %s", url, e.getMessage());
                }
            }
            ((Reader)reader).close();
            return n;
        }).sum();
    }

    private static void doParseAndRegister(ConfigurationParser parser, Reader reader, String featureName, Object location, HostedOptionKey<String[]> option) {
        try {
            parser.parseAndRegister(reader);
        }
        catch (JSONParserException | IOException e) {
            String errorMessage = e.getMessage();
            if (errorMessage == null || errorMessage.isEmpty()) {
                errorMessage = e.toString();
            }
            throw UserError.abort("Error parsing %s configuration in %s:%n%s%nVerify that the configuration matches the schema described in the %s output for option %s.", featureName, location, errorMessage, SubstrateOptionsParser.commandArgument(SubstrateOptions.PrintFlags, "+"), option.getName());
        }
    }
}

