/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.isolated;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.handles.ThreadLocalHandles;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import com.oracle.svm.graal.isolated.ClientHandle;
import com.oracle.svm.graal.isolated.CompilerHandle;
import com.oracle.svm.graal.isolated.CompilerIsolateThread;
import com.oracle.svm.graal.isolated.IsolatedCompileContext;
import org.graalvm.nativeimage.ObjectHandle;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;

public final class IsolatedCompileClient {
    private static final FastThreadLocalObject<IsolatedCompileClient> currentClient = FastThreadLocalFactory.createObject(IsolatedCompileClient.class);
    private final CompilerIsolateThread compiler;
    private final ThreadLocalHandles<ObjectHandle> handles = new ThreadLocalHandles(64);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static IsolatedCompileClient get() {
        return currentClient.get();
    }

    public static void set(IsolatedCompileClient client) {
        assert (client == null != (currentClient.get() == null));
        currentClient.set(client);
    }

    public IsolatedCompileClient(CompilerIsolateThread compiler) {
        this.compiler = compiler;
    }

    public CompilerIsolateThread getCompiler() {
        return this.compiler;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    ThreadLocalHandles<ObjectHandle> getHandleSet() {
        return this.handles;
    }

    public <T> ClientHandle<T> hand(T object) {
        return (ClientHandle)this.handles.create(object);
    }

    public <T> T unhand(ClientHandle<? extends T> handle) {
        return (T)this.handles.getObject(handle);
    }

    public CompilerHandle<String> createStringInCompiler(String s) {
        try (CTypeConversion.CCharPointerHolder cstr = CTypeConversion.toCString((CharSequence)s);){
            CompilerHandle<String> compilerHandle = IsolatedCompileClient.createStringInCompiler0(this.compiler, cstr.get());
            return compilerHandle;
        }
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static CompilerHandle<String> createStringInCompiler0(CompilerIsolateThread compiler, CCharPointer cstr) {
        return IsolatedCompileContext.get().hand(CTypeConversion.toJavaString((CCharPointer)cstr));
    }
}

