/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jni;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.ReflectionRegistry;

@Platforms(value={Platform.HOSTED_ONLY.class})
public final class JNIRuntimeAccess {
    private JNIRuntimeAccess() {
    }

    public static void register(Class<?> ... classes) {
        JNIRuntimeAccess.getSupport().register(classes);
    }

    public static void register(Executable ... methods) {
        JNIRuntimeAccess.getSupport().register(methods);
    }

    public static void register(Field ... fields) {
        JNIRuntimeAccess.register(false, fields);
    }

    public static void register(boolean finalIsWritable, Field ... fields) {
        JNIRuntimeAccess.getSupport().register(finalIsWritable, false, fields);
    }

    private static JNIRuntimeAccessibilitySupport getSupport() {
        if (!ImageSingletons.contains(JNIRuntimeAccessibilitySupport.class)) {
            throw UserError.abort("Support for JNI is not enabled. The option %s must be set.", SubstrateOptionsParser.commandArgument(SubstrateOptions.JNI, "+"));
        }
        return (JNIRuntimeAccessibilitySupport)ImageSingletons.lookup(JNIRuntimeAccessibilitySupport.class);
    }

    public static interface JNIRuntimeAccessibilitySupport
    extends ReflectionRegistry {
    }
}

