/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.core.jdk.StrictMathInvoker;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

@TargetClass(value=StrictMath.class)
final class Target_java_lang_StrictMath {
    Target_java_lang_StrictMath() {
    }

    @Substitute
    private static double sin(double a) {
        return StrictMathInvoker.sin((WordBase)WordFactory.nullPointer(), (WordBase)WordFactory.nullPointer(), a);
    }

    @Substitute
    private static double cos(double a) {
        return StrictMathInvoker.cos((WordBase)WordFactory.nullPointer(), (WordBase)WordFactory.nullPointer(), a);
    }

    @Substitute
    private static double tan(double a) {
        return StrictMathInvoker.tan((WordBase)WordFactory.nullPointer(), (WordBase)WordFactory.nullPointer(), a);
    }

    @Substitute
    private static double asin(double a) {
        return StrictMathInvoker.asin((WordBase)WordFactory.nullPointer(), (WordBase)WordFactory.nullPointer(), a);
    }

    @Substitute
    private static double acos(double a) {
        return StrictMathInvoker.acos((WordBase)WordFactory.nullPointer(), (WordBase)WordFactory.nullPointer(), a);
    }

    @Substitute
    private static double atan(double a) {
        return StrictMathInvoker.atan((WordBase)WordFactory.nullPointer(), (WordBase)WordFactory.nullPointer(), a);
    }

    @Substitute
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private static double exp(double a) {
        return StrictMathInvoker.exp((WordBase)WordFactory.nullPointer(), (WordBase)WordFactory.nullPointer(), a);
    }

    @Substitute
    private static double log(double a) {
        return StrictMathInvoker.log((WordBase)WordFactory.nullPointer(), (WordBase)WordFactory.nullPointer(), a);
    }

    @Substitute
    private static double log10(double a) {
        return StrictMathInvoker.log10((WordBase)WordFactory.nullPointer(), (WordBase)WordFactory.nullPointer(), a);
    }

    @Substitute
    private static double sqrt(double a) {
        return StrictMathInvoker.sqrt((WordBase)WordFactory.nullPointer(), (WordBase)WordFactory.nullPointer(), a);
    }

    @Substitute
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private static double cbrt(double a) {
        return StrictMathInvoker.cbrt((WordBase)WordFactory.nullPointer(), (WordBase)WordFactory.nullPointer(), a);
    }

    @Substitute
    private static double IEEEremainder(double f1, double f2) {
        return StrictMathInvoker.IEEEremainder((WordBase)WordFactory.nullPointer(), (WordBase)WordFactory.nullPointer(), f1, f2);
    }

    @Substitute
    private static double atan2(double y, double x) {
        return StrictMathInvoker.atan2((WordBase)WordFactory.nullPointer(), (WordBase)WordFactory.nullPointer(), y, x);
    }

    @Substitute
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private static double pow(double a, double b) {
        return StrictMathInvoker.pow((WordBase)WordFactory.nullPointer(), (WordBase)WordFactory.nullPointer(), a, b);
    }

    @Substitute
    private static double sinh(double x) {
        return StrictMathInvoker.sinh((WordBase)WordFactory.nullPointer(), (WordBase)WordFactory.nullPointer(), x);
    }

    @Substitute
    private static double cosh(double x) {
        return StrictMathInvoker.cosh((WordBase)WordFactory.nullPointer(), (WordBase)WordFactory.nullPointer(), x);
    }

    @Substitute
    private static double tanh(double x) {
        return StrictMathInvoker.tanh((WordBase)WordFactory.nullPointer(), (WordBase)WordFactory.nullPointer(), x);
    }

    @Substitute
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private static double hypot(double x, double y) {
        return StrictMathInvoker.hypot((WordBase)WordFactory.nullPointer(), (WordBase)WordFactory.nullPointer(), x, y);
    }

    @Substitute
    private static double expm1(double x) {
        return StrictMathInvoker.expm1((WordBase)WordFactory.nullPointer(), (WordBase)WordFactory.nullPointer(), x);
    }

    @Substitute
    private static double log1p(double x) {
        return StrictMathInvoker.log1p((WordBase)WordFactory.nullPointer(), (WordBase)WordFactory.nullPointer(), x);
    }
}

