/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.CardTable;
import com.oracle.svm.core.genscavenge.FirstObjectTable;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapPolicy;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.os.CommittedMemoryProvider;
import com.oracle.svm.core.thread.VMThreads;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

final class HeapChunkProvider {
    private final UninterruptibleUtils.AtomicPointer<AlignedHeapChunk.AlignedHeader> unusedAlignedChunks = new UninterruptibleUtils.AtomicPointer();
    private final UninterruptibleUtils.AtomicUnsigned bytesInUnusedAlignedChunks = new UninterruptibleUtils.AtomicUnsigned();
    private long firstAllocationTime;
    private static final OutOfMemoryError ALIGNED_OUT_OF_MEMORY_ERROR = new OutOfMemoryError("Could not allocate an aligned heap chunk");
    private static final OutOfMemoryError UNALIGNED_OUT_OF_MEMORY_ERROR = new OutOfMemoryError("Could not allocate an unaligned heap chunk");

    @Platforms(value={Platform.HOSTED_ONLY.class})
    HeapChunkProvider() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord getBytesInUnusedChunks() {
        return (UnsignedWord)this.bytesInUnusedAlignedChunks.get();
    }

    @AlwaysInline(value="Remove all logging when noopLog is returned by this method")
    private static Log log() {
        return Log.noopLog();
    }

    AlignedHeapChunk.AlignedHeader produceAlignedChunk() {
        UnsignedWord chunkSize = HeapPolicy.getAlignedHeapChunkSize();
        HeapChunkProvider.log().string("[HeapChunkProvider.produceAlignedChunk  chunk size: ").unsigned((WordBase)chunkSize).newline();
        AlignedHeapChunk.AlignedHeader result = this.popUnusedAlignedChunk();
        HeapChunkProvider.log().string("  unused chunk: ").hex((WordBase)result).newline();
        if (result.isNull()) {
            this.noteFirstAllocationTime();
            result = (AlignedHeapChunk.AlignedHeader)CommittedMemoryProvider.get().allocate(chunkSize, HeapPolicy.getAlignedHeapChunkAlignment(), false);
            if (result.isNull()) {
                throw ALIGNED_OUT_OF_MEMORY_ERROR;
            }
            HeapChunkProvider.log().string("  new chunk: ").hex((WordBase)result).newline();
            HeapChunkProvider.initializeChunk(result, chunkSize);
            HeapChunkProvider.resetAlignedHeapChunk(result);
        }
        assert (HeapChunk.getTopOffset(result).equal(AlignedHeapChunk.getObjectsStartOffset()));
        assert (HeapChunk.getEndOffset(result).equal(chunkSize));
        if (HeapPolicy.getZapProducedHeapChunks()) {
            HeapChunkProvider.zap(result, (WordBase)HeapPolicy.getProducedHeapChunkZapWord());
        }
        HeapPolicy.increaseEdenUsedBytes(chunkSize);
        HeapChunkProvider.log().string("  result chunk: ").hex((WordBase)result).string("  ]").newline();
        return result;
    }

    void consumeAlignedChunks(AlignedHeapChunk.AlignedHeader firstChunk) {
        UnsignedWord committedBytesAfterGC;
        assert (HeapChunk.getPrevious(firstChunk).isNull()) : "prev must be null";
        AlignedHeapChunk.AlignedHeader cur = firstChunk;
        UnsignedWord minimumHeapSize = HeapPolicy.getMinimumHeapSize();
        if (minimumHeapSize.aboveThan(committedBytesAfterGC = GCImpl.getChunkBytes().add(this.getBytesInUnusedChunks()))) {
            UnsignedWord chunksToKeep = minimumHeapSize.subtract(committedBytesAfterGC).unsignedDivide(HeapPolicy.getAlignedHeapChunkSize());
            while (cur.isNonNull() && chunksToKeep.aboveThan(0)) {
                AlignedHeapChunk.AlignedHeader next = HeapChunk.getNext(cur);
                HeapChunkProvider.cleanAlignedChunk(cur);
                this.pushUnusedAlignedChunk(cur);
                chunksToKeep = chunksToKeep.subtract(1);
                cur = next;
            }
        }
        HeapChunkProvider.freeAlignedChunkList(cur);
    }

    private static void cleanAlignedChunk(AlignedHeapChunk.AlignedHeader alignedChunk) {
        HeapChunkProvider.resetAlignedHeapChunk(alignedChunk);
        if (HeapPolicy.getZapConsumedHeapChunks()) {
            HeapChunkProvider.zap(alignedChunk, (WordBase)HeapPolicy.getConsumedHeapChunkZapWord());
        }
    }

    private void pushUnusedAlignedChunk(AlignedHeapChunk.AlignedHeader chunk) {
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            VMThreads.guaranteeOwnsThreadMutex("Should hold the lock when pushing to the global list.");
        }
        HeapChunkProvider.log().string("  old list top: ").hex((WordBase)this.unusedAlignedChunks.get()).string("  list bytes ").signed((WordBase)this.bytesInUnusedAlignedChunks.get()).newline();
        HeapChunk.setNext(chunk, this.unusedAlignedChunks.get());
        this.unusedAlignedChunks.set(chunk);
        this.bytesInUnusedAlignedChunks.addAndGet(HeapPolicy.getAlignedHeapChunkSize());
        HeapChunkProvider.log().string("  new list top: ").hex((WordBase)this.unusedAlignedChunks.get()).string("  list bytes ").signed((WordBase)this.bytesInUnusedAlignedChunks.get()).newline();
    }

    private AlignedHeapChunk.AlignedHeader popUnusedAlignedChunk() {
        HeapChunkProvider.log().string("  old list top: ").hex((WordBase)this.unusedAlignedChunks.get()).string("  list bytes ").signed((WordBase)this.bytesInUnusedAlignedChunks.get()).newline();
        AlignedHeapChunk.AlignedHeader result = this.popUnusedAlignedChunkUninterruptibly();
        if (result.isNull()) {
            return (AlignedHeapChunk.AlignedHeader)WordFactory.nullPointer();
        }
        this.bytesInUnusedAlignedChunks.subtractAndGet(HeapPolicy.getAlignedHeapChunkSize());
        HeapChunkProvider.log().string("  new list top: ").hex((WordBase)this.unusedAlignedChunks.get()).string("  list bytes ").signed((WordBase)this.bytesInUnusedAlignedChunks.get()).newline();
        return result;
    }

    @Uninterruptible(reason="Must not be interrupted by competing pushes.")
    private AlignedHeapChunk.AlignedHeader popUnusedAlignedChunkUninterruptibly() {
        AlignedHeapChunk.AlignedHeader next;
        AlignedHeapChunk.AlignedHeader result;
        do {
            if (!(result = this.unusedAlignedChunks.get()).isNull()) continue;
            return (AlignedHeapChunk.AlignedHeader)WordFactory.nullPointer();
        } while (!this.unusedAlignedChunks.compareAndSet(result, next = HeapChunk.getNext(result)));
        HeapChunk.setNext(result, (AlignedHeapChunk.AlignedHeader)WordFactory.nullPointer());
        return result;
    }

    UnalignedHeapChunk.UnalignedHeader produceUnalignedChunk(UnsignedWord objectSize) {
        UnsignedWord chunkSize = UnalignedHeapChunk.getChunkSizeForObject(objectSize);
        HeapChunkProvider.log().string("[HeapChunkProvider.produceUnalignedChunk  objectSize: ").unsigned((WordBase)objectSize).string("  chunkSize: ").hex((WordBase)chunkSize).newline();
        this.noteFirstAllocationTime();
        UnalignedHeapChunk.UnalignedHeader result = (UnalignedHeapChunk.UnalignedHeader)CommittedMemoryProvider.get().allocate(chunkSize, CommittedMemoryProvider.UNALIGNED, false);
        if (result.isNull()) {
            throw UNALIGNED_OUT_OF_MEMORY_ERROR;
        }
        HeapChunkProvider.initializeChunk(result, chunkSize);
        HeapChunkProvider.resetUnalignedChunk(result);
        assert (objectSize.belowOrEqual(HeapChunk.availableObjectMemory(result))) : "UnalignedHeapChunk insufficient for requested object";
        if (HeapPolicy.getZapProducedHeapChunks()) {
            HeapChunkProvider.zap(result, (WordBase)HeapPolicy.getProducedHeapChunkZapWord());
        }
        HeapPolicy.increaseEdenUsedBytes(chunkSize);
        HeapChunkProvider.log().string("  returns ").hex((WordBase)result).string("  ]").newline();
        return result;
    }

    static void consumeUnalignedChunks(UnalignedHeapChunk.UnalignedHeader firstChunk) {
        HeapChunkProvider.freeUnalignedChunkList(firstChunk);
    }

    private static void initializeChunk(HeapChunk.Header<?> that, UnsignedWord chunkSize) {
        HeapChunk.setEndOffset(that, chunkSize);
    }

    private static void resetChunkHeader(HeapChunk.Header<?> chunk, Pointer objectsStart) {
        HeapChunk.setTopPointer(chunk, objectsStart);
        HeapChunk.setSpace(chunk, null);
        HeapChunk.setNext(chunk, (HeapChunk.Header)WordFactory.nullPointer());
        HeapChunk.setPrevious(chunk, (HeapChunk.Header)WordFactory.nullPointer());
    }

    private static void resetAlignedHeapChunk(AlignedHeapChunk.AlignedHeader chunk) {
        HeapChunkProvider.resetChunkHeader(chunk, AlignedHeapChunk.getObjectsStart(chunk));
        CardTable.cleanTableToPointer(AlignedHeapChunk.getCardTableStart(chunk), AlignedHeapChunk.getCardTableLimit(chunk));
        FirstObjectTable.initializeTableToLimit(AlignedHeapChunk.getFirstObjectTableStart(chunk), AlignedHeapChunk.getFirstObjectTableLimit(chunk));
    }

    private static void resetUnalignedChunk(UnalignedHeapChunk.UnalignedHeader result) {
        HeapChunkProvider.resetChunkHeader(result, UnalignedHeapChunk.getObjectStart(result));
        CardTable.cleanTableToPointer(UnalignedHeapChunk.getCardTableStart(result), UnalignedHeapChunk.getCardTableLimit(result));
    }

    private static void zap(HeapChunk.Header<?> chunk, WordBase value) {
        Pointer start = HeapChunk.getTopPointer(chunk);
        Pointer limit = HeapChunk.getEndPointer(chunk);
        HeapChunkProvider.log().string("  zap chunk: ").hex((WordBase)chunk).string("  start: ").hex((WordBase)start).string("  limit: ").hex((WordBase)limit).string("  value: ").hex(value).newline();
        Pointer p = start;
        while (p.belowThan((UnsignedWord)limit)) {
            p.writeWord(0, value);
            p = p.add(FrameAccess.wordSize());
        }
    }

    Log report(Log log, boolean traceHeapChunks) {
        log.string("[Unused:").indent(true);
        log.string("aligned: ").signed((WordBase)this.bytesInUnusedAlignedChunks.get()).string("/").signed((WordBase)((UnsignedWord)this.bytesInUnusedAlignedChunks.get()).unsignedDivide(HeapPolicy.getAlignedHeapChunkSize()));
        if (traceHeapChunks && this.unusedAlignedChunks.get().isNonNull()) {
            log.newline().string("aligned chunks:").redent(true);
            AlignedHeapChunk.AlignedHeader aChunk = this.unusedAlignedChunks.get();
            while (aChunk.isNonNull()) {
                log.newline().hex((WordBase)aChunk).string(" (").hex((WordBase)AlignedHeapChunk.getObjectsStart(aChunk)).string("-").hex((WordBase)HeapChunk.getTopPointer(aChunk)).string(")");
                aChunk = HeapChunk.getNext(aChunk);
            }
            log.redent(false);
        }
        log.redent(false).string("]");
        return log;
    }

    boolean walkHeapChunks(MemoryWalker.Visitor visitor) {
        boolean continueVisiting = true;
        MemoryWalker.HeapChunkAccess<AlignedHeapChunk.AlignedHeader> access = AlignedHeapChunk.getMemoryWalkerAccess();
        AlignedHeapChunk.AlignedHeader aChunk = this.unusedAlignedChunks.get();
        while (continueVisiting && aChunk.isNonNull()) {
            continueVisiting = visitor.visitHeapChunk(aChunk, access);
            aChunk = HeapChunk.getNext(aChunk);
        }
        return continueVisiting;
    }

    private void noteFirstAllocationTime() {
        if (this.firstAllocationTime == 0L) {
            this.firstAllocationTime = System.nanoTime();
        }
    }

    long getFirstAllocationTime() {
        return this.firstAllocationTime;
    }

    boolean slowlyFindPointer(Pointer p) {
        AlignedHeapChunk.AlignedHeader chunk = this.unusedAlignedChunks.get();
        while (chunk.isNonNull()) {
            Pointer chunkPtr = HeapChunk.asPointer(chunk);
            if (p.aboveOrEqual((UnsignedWord)chunkPtr) && p.belowThan((UnsignedWord)chunkPtr.add(HeapPolicy.getAlignedHeapChunkSize()))) {
                return true;
            }
            chunk = HeapChunk.getNext(chunk);
        }
        return false;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void tearDown() {
        HeapChunkProvider.freeAlignedChunkList(this.unusedAlignedChunks.get());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static void freeAlignedChunkList(AlignedHeapChunk.AlignedHeader first) {
        AlignedHeapChunk.AlignedHeader chunk = first;
        while (chunk.isNonNull()) {
            AlignedHeapChunk.AlignedHeader next = HeapChunk.getNext(chunk);
            HeapChunkProvider.freeAlignedChunk(chunk);
            chunk = next;
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static void freeUnalignedChunkList(UnalignedHeapChunk.UnalignedHeader first) {
        UnalignedHeapChunk.UnalignedHeader chunk = first;
        while (chunk.isNonNull()) {
            UnalignedHeapChunk.UnalignedHeader next = HeapChunk.getNext(chunk);
            HeapChunkProvider.freeUnalignedChunk(chunk);
            chunk = next;
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void freeAlignedChunk(AlignedHeapChunk.AlignedHeader chunk) {
        CommittedMemoryProvider.get().free(chunk, HeapPolicy.getAlignedHeapChunkSize(), HeapPolicy.getAlignedHeapChunkAlignment(), false);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void freeUnalignedChunk(UnalignedHeapChunk.UnalignedHeader chunk) {
        CommittedMemoryProvider.get().free(chunk, HeapChunkProvider.unalignedChunkSize(chunk), CommittedMemoryProvider.UNALIGNED, false);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static UnsignedWord unalignedChunkSize(UnalignedHeapChunk.UnalignedHeader chunk) {
        return HeapChunk.getEndOffset(chunk);
    }
}

