/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.hosted.AbstractNativeImageClassLoaderSupport;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.util.ModuleSupport;
import java.io.File;
import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class NativeImageClassLoaderSupport
extends AbstractNativeImageClassLoaderSupport {
    private final List<Path> imagemp;
    private final List<Path> buildmp;
    private final ClassLoader classLoader;
    private final Function<String, Optional<Module>> moduleFinder;
    private final ModuleLayer.Controller moduleController;

    NativeImageClassLoaderSupport(ClassLoader defaultSystemClassLoader, String[] classpath, String[] modulePath) {
        super(defaultSystemClassLoader, classpath);
        this.imagemp = Arrays.stream(modulePath).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toUnmodifiableList());
        this.buildmp = Arrays.stream(System.getProperty("jdk.module.path", "").split(File.pathSeparator)).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toUnmodifiableList());
        this.moduleController = NativeImageClassLoaderSupport.createModuleController((Path[])this.imagemp.toArray(Path[]::new), this.classPathClassLoader);
        ModuleLayer moduleLayer = this.moduleController.layer();
        if (moduleLayer.modules().isEmpty()) {
            this.classLoader = this.classPathClassLoader;
            this.moduleFinder = null;
        } else {
            this.classLoader = moduleLayer.modules().iterator().next().getClassLoader();
            this.moduleFinder = moduleLayer::findModule;
        }
    }

    private static ModuleLayer.Controller createModuleController(Path[] modulePaths, ClassLoader parent) {
        ModuleFinder finder = ModuleFinder.of(modulePaths);
        List<Configuration> parents = List.of(ModuleLayer.boot().configuration());
        Set<String> moduleNames = finder.findAll().stream().map(moduleReference -> moduleReference.descriptor().name()).collect(Collectors.toSet());
        Configuration configuration = Configuration.resolve(finder, parents, finder, moduleNames);
        return ModuleLayer.defineModulesWithOneLoader(configuration, List.of(ModuleLayer.boot()), parent);
    }

    @Override
    public List<Path> modulepath() {
        return Stream.concat(this.buildmp.stream(), this.imagemp.stream()).collect(Collectors.toList());
    }

    @Override
    List<Path> applicationModulePath() {
        return this.imagemp;
    }

    @Override
    public Optional<Object> findModule(String moduleName) {
        return Optional.ofNullable(this.moduleFinder).flatMap(f -> (Optional)f.apply(moduleName));
    }

    @Override
    Class<?> loadClassFromModule(Object module, String className) throws ClassNotFoundException {
        if (module == null) {
            return Class.forName(className, false, this.classPathClassLoader);
        }
        if (!(module instanceof Module)) {
            throw new IllegalArgumentException("Argument `module` is not an instance of java.lang.Module");
        }
        Module m = (Module)module;
        if (m.getClassLoader() != this.classLoader) {
            throw new IllegalArgumentException("Argument `module` is java.lang.Module from different ClassLoader");
        }
        Class<?> clazz = Class.forName(m, className);
        if (clazz == null) {
            throw new ClassNotFoundException(className);
        }
        return clazz;
    }

    @Override
    ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public void initAllClasses(ForkJoinPool executor, ImageClassLoader imageClassLoader) {
        new ClassInitWithModules(executor, imageClassLoader, this).init();
    }

    private static class ClassInitWithModules
    extends AbstractNativeImageClassLoaderSupport.ClassInit {
        ClassInitWithModules(ForkJoinPool executor, ImageClassLoader imageClassLoader, AbstractNativeImageClassLoaderSupport nativeImageClassLoader) {
            super(executor, imageClassLoader, nativeImageClassLoader);
        }

        @Override
        protected void init() {
            HashSet<String> modules = new HashSet<String>();
            modules.add("jdk.internal.vm.ci");
            ClassInitWithModules.addOptionalModule(modules, "org.graalvm.sdk");
            ClassInitWithModules.addOptionalModule(modules, "jdk.internal.vm.compiler");
            ClassInitWithModules.addOptionalModule(modules, "com.oracle.graal.graal_enterprise");
            String includeModulesStr = System.getProperty("substratevm.ImageIncludeBuiltinModules");
            if (includeModulesStr != null) {
                modules.addAll(Arrays.asList(includeModulesStr.split(",")));
            }
            for (String moduleResource : ModuleSupport.getSystemModuleResources(modules)) {
                this.handleClassInModuleResource(moduleResource);
            }
            for (String moduleResource : ModuleSupport.getModuleResources(this.nativeImageClassLoader.modulepath())) {
                this.handleClassInModuleResource(moduleResource);
            }
            super.init();
        }

        private void handleClassInModuleResource(String moduleResource) {
            if (moduleResource.endsWith(".class")) {
                this.executor.execute(() -> this.handleClassFileName(ClassInitWithModules.classFileWithoutSuffix(moduleResource), '/'));
            }
        }

        private static void addOptionalModule(Set<String> modules, String name) {
            if (ModuleSupport.hasSystemModule((String)name)) {
                modules.add(name);
            }
        }
    }
}

