/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk11;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.LocalizationFeature;
import java.text.spi.BreakIteratorProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.spi.LocaleServiceProvider;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.hosted.Feature;
import sun.text.spi.JavaTimeDateTimePatternProvider;

@AutomaticFeature
final class LocalizationFeatureJDK11OrLater
extends LocalizationFeature {
    private static final List<Class<? extends LocaleServiceProvider>> jdk9PlusClasses = Collections.singletonList(JavaTimeDateTimePatternProvider.class);

    LocalizationFeatureJDK11OrLater() {
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return JavaVersionUtil.JAVA_SPEC >= 11;
    }

    @Override
    protected void addResourceBundles() {
        super.addResourceBundles();
        this.addBundleToCache(this.localeData(BreakIteratorProvider.class).getBreakIteratorResources(this.imageLocale));
    }

    @Override
    protected List<Class<? extends LocaleServiceProvider>> getSpiClasses() {
        ArrayList<Class<? extends LocaleServiceProvider>> allClasses = new ArrayList<Class<? extends LocaleServiceProvider>>(super.getSpiClasses());
        allClasses.addAll(jdk9PlusClasses);
        return allClasses;
    }
}

