/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.llvm.util;

import com.oracle.svm.core.graal.llvm.util.LLVMIRBuilder;
import com.oracle.svm.shadowed.org.bytedeco.llvm.LLVM.LLVMBasicBlockRef;
import com.oracle.svm.shadowed.org.bytedeco.llvm.LLVM.LLVMTypeRef;
import com.oracle.svm.shadowed.org.bytedeco.llvm.LLVM.LLVMValueRef;

class LLVMHelperFunctions {
    private LLVMIRBuilder builder;
    private LLVMValueRef intToObjectFunction;
    private LLVMValueRef loadObjectFromUntrackedPointerFunction;
    private LLVMValueRef atomicObjectXchgFunction;
    private LLVMValueRef objectsCmpxchgFunction;
    private LLVMValueRef intToCompressedObjectFunction;
    private LLVMValueRef loadCompressedObjectFromUntrackedPointerFunction;
    private LLVMValueRef atomicCompressedObjectXchgFunction;
    private LLVMValueRef compressedObjectsCmpxchgFunction;
    private LLVMValueRef[] compressFunctions;
    private LLVMValueRef[] nonNullCompressFunctions;
    private LLVMValueRef[] uncompressFunctions;
    private LLVMValueRef[] nonNullUncompressFunctions;
    private static final int MAX_COMPRESS_SHIFT = 3;
    private static final String INT_TO_OBJECT_FUNCTION_NAME = "__llvm_int_to_object";
    private static final String INT_TO_COMPRESSED_OBJECT_FUNCTION_NAME = "__llvm_int_to_compressed_object";
    private static final String LOAD_OBJECT_FROM_UNTRACKED_POINTER_FUNCTION_NAME = "__llvm_load_object_from_untracked_pointer";
    private static final String LOAD_COMPRESSED_OBJECT_FROM_UNTRACKED_POINTER_FUNCTION_NAME = "__llvm_load_compressed_object_from_untracked_pointer";
    private static final String ATOMIC_OBJECT_XCHG_FUNCTION_NAME = "__llvm_atomic_object_xchg";
    private static final String ATOMIC_COMPRESSED_OBJECT_XCHG_FUNCTION_NAME = "__llvm_atomic_compressed_object_xchg";
    private static final String OBJECTS_CMPXCHG_FUNCTION_NAME = "__llvm_objects_cmpxchg";
    private static final String COMPRESSED_OBJECTS_CMPXCHG_FUNCTION_NAME = "__llvm_compressed_objects_cmpxchg";
    private static final String COMPRESS_FUNCTION_BASE_NAME = "__llvm_compress";
    private static final String UNCOMPRESS_FUNCTION_BASE_NAME = "__llvm_uncompress";

    LLVMHelperFunctions(LLVMIRBuilder primary) {
        this.builder = new LLVMIRBuilder(primary);
    }

    LLVMValueRef getIntToObjectFunction(boolean compressed) {
        if (!compressed && this.intToObjectFunction == null) {
            this.intToObjectFunction = this.buildIntToObjectFunction(false);
        } else if (compressed && this.intToCompressedObjectFunction == null) {
            this.intToCompressedObjectFunction = this.buildIntToObjectFunction(true);
        }
        return compressed ? this.intToCompressedObjectFunction : this.intToObjectFunction;
    }

    LLVMValueRef getLoadObjectFromUntrackedPointerFunction(boolean compressed) {
        if (!compressed && this.loadObjectFromUntrackedPointerFunction == null) {
            this.loadObjectFromUntrackedPointerFunction = this.buildLoadObjectFromUntrackedPointerFunction(false);
        } else if (compressed && this.loadCompressedObjectFromUntrackedPointerFunction == null) {
            this.loadCompressedObjectFromUntrackedPointerFunction = this.buildLoadObjectFromUntrackedPointerFunction(true);
        }
        return compressed ? this.loadCompressedObjectFromUntrackedPointerFunction : this.loadObjectFromUntrackedPointerFunction;
    }

    LLVMValueRef getAtomicObjectXchgFunction(boolean compressed) {
        if (!compressed && this.atomicObjectXchgFunction == null) {
            this.atomicObjectXchgFunction = this.buildAtomicObjectXchgFunction(false);
        } else if (compressed && this.atomicCompressedObjectXchgFunction == null) {
            this.atomicCompressedObjectXchgFunction = this.buildAtomicObjectXchgFunction(true);
        }
        return compressed ? this.atomicCompressedObjectXchgFunction : this.atomicObjectXchgFunction;
    }

    LLVMValueRef getCmpxchgFunction(boolean compressed) {
        if (!compressed && this.objectsCmpxchgFunction == null) {
            this.objectsCmpxchgFunction = this.buildObjectsCmpxchgFunction(false);
        } else if (compressed && this.compressedObjectsCmpxchgFunction == null) {
            this.compressedObjectsCmpxchgFunction = this.buildObjectsCmpxchgFunction(true);
        }
        return compressed ? this.compressedObjectsCmpxchgFunction : this.objectsCmpxchgFunction;
    }

    LLVMValueRef getCompressFunction(boolean nonNull, int shift) {
        if (nonNull) {
            if (this.nonNullCompressFunctions == null) {
                this.nonNullCompressFunctions = new LLVMValueRef[3];
            }
            if (this.nonNullCompressFunctions[shift] == null) {
                this.nonNullCompressFunctions[shift] = this.buildCompressFunction(true, shift);
            }
        } else {
            if (this.compressFunctions == null) {
                this.compressFunctions = new LLVMValueRef[3];
            }
            if (this.compressFunctions[shift] == null) {
                this.compressFunctions[shift] = this.buildCompressFunction(false, shift);
            }
        }
        return nonNull ? this.nonNullCompressFunctions[shift] : this.compressFunctions[shift];
    }

    LLVMValueRef getUncompressFunction(boolean nonNull, int shift) {
        if (nonNull) {
            if (this.nonNullUncompressFunctions == null) {
                this.nonNullUncompressFunctions = new LLVMValueRef[3];
            }
            if (this.nonNullUncompressFunctions[shift] == null) {
                this.nonNullUncompressFunctions[shift] = this.buildUncompressFunction(true, shift);
            }
        } else {
            if (this.uncompressFunctions == null) {
                this.uncompressFunctions = new LLVMValueRef[3];
            }
            if (this.uncompressFunctions[shift] == null) {
                this.uncompressFunctions[shift] = this.buildUncompressFunction(false, shift);
            }
        }
        return nonNull ? this.nonNullUncompressFunctions[shift] : this.uncompressFunctions[shift];
    }

    private LLVMValueRef buildIntToObjectFunction(boolean compressed) {
        String funcName = compressed ? INT_TO_COMPRESSED_OBJECT_FUNCTION_NAME : INT_TO_OBJECT_FUNCTION_NAME;
        LLVMValueRef func = this.builder.addFunction(funcName, this.builder.functionType(this.builder.objectType(compressed), this.builder.wordType()));
        LLVMIRBuilder.setLinkage(func, LLVMIRBuilder.LinkageType.LinkOnce);
        this.builder.setFunctionAttribute(func, LLVMIRBuilder.Attribute.AlwaysInline);
        this.builder.setFunctionAttribute(func, LLVMIRBuilder.Attribute.GCLeafFunction);
        LLVMBasicBlockRef block = this.builder.appendBasicBlock(func, "main");
        this.builder.positionAtEnd(block);
        LLVMValueRef arg = LLVMIRBuilder.getParam(func, 0);
        LLVMValueRef ref = this.builder.buildLLVMIntToPtr(arg, this.builder.objectType(compressed));
        this.builder.buildRet(ref);
        return func;
    }

    private LLVMValueRef buildLoadObjectFromUntrackedPointerFunction(boolean compressed) {
        String funcName = compressed ? LOAD_COMPRESSED_OBJECT_FROM_UNTRACKED_POINTER_FUNCTION_NAME : LOAD_OBJECT_FROM_UNTRACKED_POINTER_FUNCTION_NAME;
        LLVMValueRef func = this.builder.addFunction(funcName, this.builder.functionType(this.builder.objectType(compressed), this.builder.rawPointerType()));
        LLVMIRBuilder.setLinkage(func, LLVMIRBuilder.LinkageType.LinkOnce);
        this.builder.setFunctionAttribute(func, LLVMIRBuilder.Attribute.AlwaysInline);
        this.builder.setFunctionAttribute(func, LLVMIRBuilder.Attribute.GCLeafFunction);
        LLVMBasicBlockRef block = this.builder.appendBasicBlock(func, "main");
        this.builder.positionAtEnd(block);
        LLVMValueRef address = LLVMIRBuilder.getParam(func, 0);
        LLVMValueRef castedAddress = this.builder.buildBitcast(address, this.builder.pointerType(this.builder.objectType(compressed), false, false));
        LLVMValueRef loadedValue = this.builder.buildLoad(castedAddress);
        this.builder.buildRet(loadedValue);
        return func;
    }

    private LLVMValueRef buildAtomicObjectXchgFunction(boolean compressed) {
        String funcName = compressed ? ATOMIC_COMPRESSED_OBJECT_XCHG_FUNCTION_NAME : ATOMIC_OBJECT_XCHG_FUNCTION_NAME;
        LLVMValueRef func = this.builder.addFunction(funcName, this.builder.functionType(this.builder.objectType(compressed), this.builder.objectType(false), this.builder.objectType(compressed)));
        LLVMIRBuilder.setLinkage(func, LLVMIRBuilder.LinkageType.LinkOnce);
        this.builder.setFunctionAttribute(func, LLVMIRBuilder.Attribute.AlwaysInline);
        this.builder.setFunctionAttribute(func, LLVMIRBuilder.Attribute.GCLeafFunction);
        LLVMBasicBlockRef block = this.builder.appendBasicBlock(func, "main");
        this.builder.positionAtEnd(block);
        LLVMValueRef address = LLVMIRBuilder.getParam(func, 0);
        LLVMValueRef value = LLVMIRBuilder.getParam(func, 1);
        LLVMValueRef castedValue = this.builder.buildPtrToInt(value);
        LLVMValueRef ret = this.builder.buildLLVMAtomicXchg(address, castedValue);
        ret = this.builder.buildLLVMIntToPtr(ret, this.builder.objectType(compressed));
        this.builder.buildRet(ret);
        return func;
    }

    private LLVMValueRef buildObjectsCmpxchgFunction(boolean compressed) {
        String funcName = compressed ? COMPRESSED_OBJECTS_CMPXCHG_FUNCTION_NAME : OBJECTS_CMPXCHG_FUNCTION_NAME;
        LLVMTypeRef exchangeType = this.builder.objectType(compressed);
        LLVMValueRef func = this.builder.addFunction(funcName, this.builder.functionType(exchangeType, this.builder.pointerType(exchangeType, true, compressed), exchangeType, exchangeType));
        LLVMIRBuilder.setLinkage(func, LLVMIRBuilder.LinkageType.LinkOnce);
        this.builder.setFunctionAttribute(func, LLVMIRBuilder.Attribute.AlwaysInline);
        this.builder.setFunctionAttribute(func, LLVMIRBuilder.Attribute.GCLeafFunction);
        LLVMBasicBlockRef block = this.builder.appendBasicBlock(func, "main");
        this.builder.positionAtEnd(block);
        LLVMValueRef addr = LLVMIRBuilder.getParam(func, 0);
        LLVMValueRef expected = LLVMIRBuilder.getParam(func, 1);
        LLVMValueRef newVal = LLVMIRBuilder.getParam(func, 2);
        LLVMValueRef result = this.builder.buildAtomicCmpXchg(addr, expected, newVal, true);
        this.builder.buildRet(result);
        return func;
    }

    private LLVMValueRef buildCompressFunction(boolean nonNull, int shift) {
        String funcName = COMPRESS_FUNCTION_BASE_NAME + (nonNull ? "_nonNull" : "") + "_" + shift;
        LLVMValueRef func = this.builder.addFunction(funcName, this.builder.functionType(this.builder.objectType(true), this.builder.objectType(false), this.builder.wordType()));
        LLVMIRBuilder.setLinkage(func, LLVMIRBuilder.LinkageType.LinkOnce);
        this.builder.setFunctionAttribute(func, LLVMIRBuilder.Attribute.AlwaysInline);
        this.builder.setFunctionAttribute(func, LLVMIRBuilder.Attribute.GCLeafFunction);
        LLVMBasicBlockRef block = this.builder.appendBasicBlock(func, "main");
        this.builder.positionAtEnd(block);
        LLVMValueRef uncompressed = this.builder.buildPtrToInt(LLVMIRBuilder.getParam(func, 0));
        LLVMValueRef heapBase = LLVMIRBuilder.getParam(func, 1);
        LLVMValueRef compressed = this.builder.buildSub(uncompressed, heapBase);
        if (!nonNull) {
            LLVMValueRef isNull = this.builder.buildIsNull(uncompressed);
            compressed = this.builder.buildSelect(isNull, uncompressed, compressed);
        }
        if (shift != 0) {
            compressed = this.builder.buildShr(compressed, this.builder.constantInt(shift));
        }
        compressed = this.builder.buildLLVMIntToPtr(compressed, this.builder.objectType(true));
        this.builder.buildRet(compressed);
        return func;
    }

    private LLVMValueRef buildUncompressFunction(boolean nonNull, int shift) {
        String funcName = UNCOMPRESS_FUNCTION_BASE_NAME + (nonNull ? "_nonNull" : "") + "_" + shift;
        LLVMValueRef func = this.builder.addFunction(funcName, this.builder.functionType(this.builder.objectType(false), this.builder.objectType(true), this.builder.wordType()));
        LLVMIRBuilder.setLinkage(func, LLVMIRBuilder.LinkageType.LinkOnce);
        this.builder.setFunctionAttribute(func, LLVMIRBuilder.Attribute.AlwaysInline);
        this.builder.setFunctionAttribute(func, LLVMIRBuilder.Attribute.GCLeafFunction);
        LLVMBasicBlockRef block = this.builder.appendBasicBlock(func, "main");
        this.builder.positionAtEnd(block);
        LLVMValueRef compressed = this.builder.buildPtrToInt(LLVMIRBuilder.getParam(func, 0));
        LLVMValueRef heapBase = LLVMIRBuilder.getParam(func, 1);
        if (shift != 0) {
            compressed = this.builder.buildShl(compressed, this.builder.constantInt(shift));
        }
        LLVMValueRef uncompressed = this.builder.buildAdd(compressed, heapBase);
        if (!nonNull) {
            LLVMValueRef isNull = this.builder.buildIsNull(compressed);
            uncompressed = this.builder.buildSelect(isNull, compressed, uncompressed);
        }
        uncompressed = this.builder.buildLLVMIntToPtr(uncompressed, this.builder.objectType(false));
        this.builder.buildRet(uncompressed);
        return func;
    }
}

