/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk;

import java.lang.reflect.Modifier;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsProvider;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.BrowserUtils;

public class ReflectionDetailsProvider
extends DetailsProvider.Basic {
    private static final String CLASS_MASK = "java.lang.Class";
    private static final String CONSTRUCTOR_MASK = "java.lang.reflect.Constructor";
    private static final String METHOD_MASK = "java.lang.reflect.Method";
    private static final String FIELD_MASK = "java.lang.reflect.Field";
    private static final String PARAMETER_MASK = "java.lang.reflect.Parameter";

    public ReflectionDetailsProvider() {
        super(CLASS_MASK, CONSTRUCTOR_MASK, METHOD_MASK, FIELD_MASK, PARAMETER_MASK);
    }

    @Override
    public String getDetailsString(String className, Instance instance, Heap heap) {
        if (CLASS_MASK.equals(className)) {
            JavaClass jclass;
            String name = DetailsUtils.getInstanceFieldString(instance, "name", heap);
            if (name == null && CLASS_MASK.equals(instance.getJavaClass().getName()) && (jclass = heap.getJavaClassByID(instance.getInstanceId())) != null) {
                name = BrowserUtils.getSimpleType(jclass.getName());
            }
            return name;
        }
        if (CONSTRUCTOR_MASK.equals(className)) {
            Object value = instance.getValueOfField("clazz");
            if (value instanceof Instance) {
                return this.getDetailsString(CLASS_MASK, (Instance)value, heap);
            }
        } else {
            if (METHOD_MASK.equals(className)) {
                return DetailsUtils.getInstanceFieldString(instance, "name", heap);
            }
            if (FIELD_MASK.equals(className)) {
                int mod = DetailsUtils.getIntFieldValue(instance, "modifiers", 0);
                String type = DetailsUtils.getInstanceFieldString(instance, "type", heap);
                String name = DetailsUtils.getInstanceFieldString(instance, "name", heap);
                String clazz = DetailsUtils.getInstanceFieldString(instance, "clazz", heap);
                return (mod == 0 ? "" : Modifier.toString(mod) + " ") + type + " " + clazz + "." + name;
            }
            if (PARAMETER_MASK.equals(className)) {
                return DetailsUtils.getInstanceFieldString(instance, "name", heap);
            }
        }
        return null;
    }
}

