/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.agentscript;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.GenerateLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.tools.agentscript.impl.AccessorFrameLibrary;
import com.oracle.truffle.tools.agentscript.impl.DefaultFrameLibrary;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

@GenerateLibrary(defaultExportLookupEnabled=true)
@GenerateLibrary.DefaultExport(value=DefaultFrameLibrary.class)
public abstract class FrameLibrary
extends Library {
    protected FrameLibrary() {
    }

    public static FrameLibrary getUncached() {
        return UncachedDefault.DEFAULT;
    }

    public Object readMember(Query env, String member) throws UnknownIdentifierException {
        return FrameLibrary.getUncached().readMember(env, member);
    }

    public void writeMember(Query env, String member, Object value) throws UnknownIdentifierException, UnsupportedTypeException {
        FrameLibrary.getUncached().writeMember(env, member, value);
    }

    public void collectNames(Query env, Set<String> names) throws InteropException {
        FrameLibrary.getUncached().collectNames(env, names);
    }

    static {
        AccessorFrameLibrary accessor = new AccessorFrameLibrary(){

            @Override
            protected Query create(Node where, Frame frame, TruffleInstrument.Env env) {
                FrameLibrary frameLibrary = UncachedDefault.DEFAULT;
                Objects.requireNonNull(frameLibrary);
                return frameLibrary.new Query(where, frame, env);
            }
        };
        assert (AccessorFrameLibrary.DEFAULT == accessor);
    }

    private static final class UncachedDefault
    extends FrameLibrary {
        static final FrameLibrary DEFAULT = new UncachedDefault();

        private UncachedDefault() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object readMember(Query env, String member) throws UnknownIdentifierException {
            InteropLibrary iop = (InteropLibrary)InteropLibrary.getFactory().getUncached();
            for (Scope scope : env.findLocalScopes()) {
                if (scope == null) continue;
                if (member.equals(scope.getReceiverName())) {
                    return scope.getReceiver();
                }
                Object variable = UncachedDefault.readMemberImpl(member, scope.getVariables(), iop);
                if (variable != null) {
                    return variable;
                }
                Object argument = UncachedDefault.readMemberImpl(member, scope.getArguments(), iop);
                if (argument == null) continue;
                return argument;
            }
            throw UnknownIdentifierException.create((String)member);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void writeMember(Query env, String member, Object value) throws UnknownIdentifierException, UnsupportedTypeException {
            InteropLibrary iop = (InteropLibrary)InteropLibrary.getFactory().getUncached();
            for (Scope scope : env.findLocalScopes()) {
                if (scope == null) continue;
                if (UncachedDefault.writeMemberImpl(member, value, scope.getVariables(), iop)) {
                    return;
                }
                if (!UncachedDefault.writeMemberImpl(member, value, scope.getArguments(), iop)) continue;
                return;
            }
            throw UnknownIdentifierException.create((String)member);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void collectNames(Query env, Set<String> names) throws InteropException {
            InteropLibrary iop = (InteropLibrary)InteropLibrary.getFactory().getUncached();
            for (Scope scope : env.findLocalScopes()) {
                if (scope == null) continue;
                String receiverName = scope.getReceiverName();
                if (receiverName != null) {
                    names.add(receiverName);
                }
                UncachedDefault.readMemberNames(names, scope.getVariables(), iop);
                UncachedDefault.readMemberNames(names, scope.getArguments(), iop);
            }
        }

        public boolean accepts(Object receiver) {
            return receiver instanceof Query;
        }

        static Object readMemberImpl(String name, Object map, InteropLibrary iop) {
            if (map != null && iop.hasMembers(map)) {
                try {
                    return iop.readMember(map, name);
                }
                catch (InteropException e) {
                    return null;
                }
            }
            return null;
        }

        static boolean writeMemberImpl(String name, Object value, Object map, InteropLibrary iop) throws UnknownIdentifierException, UnsupportedTypeException {
            if (map != null && iop.hasMembers(map)) {
                try {
                    iop.writeMember(map, name, value);
                    return true;
                }
                catch (UnsupportedMessageException ex) {
                    return false;
                }
            }
            return false;
        }

        static void readMemberNames(Set<String> names, Object map, InteropLibrary iop) throws InteropException {
            if (map != null && iop.hasMembers(map)) {
                Object members = iop.getMembers(map);
                long size = iop.getArraySize(members);
                for (long i = 0L; i < size; ++i) {
                    Object at = iop.readArrayElement(members, i);
                    if (!(at instanceof String)) continue;
                    names.add((String)at);
                }
            }
        }
    }

    public final class Query {
        private final Node where;
        private final Frame frame;
        private final TruffleInstrument.Env env;

        Query(Node where, Frame frame, TruffleInstrument.Env env) {
            this.where = where;
            this.frame = frame;
            this.env = env;
        }

        public Iterable<Scope> findLocalScopes() {
            return this.env != null ? this.env.findLocalScopes(this.where, this.frame) : Collections.emptySet();
        }

        public Frame frame() {
            return this.frame;
        }
    }
}

