/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.utils;

import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.source.Source;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.graalvm.options.OptionValues;
import org.graalvm.tools.lsp.instrument.LSPInstrument;
import org.graalvm.tools.lsp.server.utils.TextDocumentSurrogateMap;

public final class SourcePredicateBuilder {
    private final List<Predicate<Source>> predicates = new ArrayList<Predicate<Source>>();

    private SourcePredicateBuilder() {
    }

    public SourcePredicateBuilder uriOrTruffleName(URI uri) {
        SourceSectionFilter.SourcePredicate predicate = src -> src.getURI().equals(uri) || "truffle".equals(src.getURI().getScheme()) && src.getName() != null && src.getName().equals(uri.getPath());
        this.predicates.add((Predicate<Source>)predicate);
        return this;
    }

    public SourcePredicateBuilder language(LanguageInfo languageInfo) {
        SourceSectionFilter.SourcePredicate predicate = src -> languageInfo.getId().equals(src.getLanguage()) || src.getMimeType() != null && languageInfo.getMimeTypes().contains(src.getMimeType());
        this.predicates.add((Predicate<Source>)predicate);
        return this;
    }

    public SourcePredicateBuilder excludeInternal(OptionValues options) {
        boolean includeInternal = (Boolean)options.get(LSPInstrument.Internal);
        if (!includeInternal) {
            SourceSectionFilter.SourcePredicate predicate = src -> !src.isInternal();
            this.predicates.add((Predicate<Source>)predicate);
        }
        return this;
    }

    public SourcePredicateBuilder newestSource(TextDocumentSurrogateMap surrogateMap) {
        this.predicates.add(src -> surrogateMap.isSourceNewestInSurrogate((Source)src));
        return this;
    }

    public SourceSectionFilter.SourcePredicate build() {
        Predicate predicate = (Predicate)this.predicates.stream().reduce((predicateA, predicateB) -> predicateA.and(predicateB)).get();
        return src -> predicate.test(src);
    }

    public static SourcePredicateBuilder newBuilder() {
        return new SourcePredicateBuilder();
    }
}

