/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.utils;

import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.LoadSourceSectionEvent;
import com.oracle.truffle.api.instrumentation.LoadSourceSectionListener;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.util.logging.Level;
import org.graalvm.tools.lsp.server.utils.NearestNode;
import org.graalvm.tools.lsp.server.utils.SourceUtils;

public final class NearestSectionsFinder {
    private NearestSectionsFinder() {
    }

    public static NearestNode findNearestNode(Source source, int line, int character, TruffleInstrument.Env env, TruffleLogger logger) {
        int oneBasedLineNumber = SourceUtils.zeroBasedLineToOneBasedLine(line, source);
        int oneBasedColumn = SourceUtils.zeroBasedColumnToOneBasedColumn(line, oneBasedLineNumber, character, source);
        NearestNode nearestNode = NearestSectionsFinder.findNearestNodeOneBased(oneBasedLineNumber, oneBasedColumn, source, env);
        Node node = nearestNode.getNode();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "nearestNode: {0}\t{1}-\t{2}", new Object[]{node != null ? node.getClass().getSimpleName() : "--NULL--", nearestNode.getLocationType(), node != null ? node.getSourceSection() : ""});
        }
        return nearestNode;
    }

    public static NearestNode findExprNodeBeforePos(Source source, int line, int column, TruffleInstrument.Env env) {
        int oneBasedLine = SourceUtils.zeroBasedLineToOneBasedLine(line, source);
        int oneBasedColumn = SourceUtils.zeroBasedColumnToOneBasedColumn(line, oneBasedLine, column, source);
        SectionsBefore sectionsBefore = new SectionsBefore(oneBasedLine, oneBasedColumn);
        Class[] exprTags = new Class[]{StandardTags.ExpressionTag.class, StandardTags.ReadVariableTag.class, StandardTags.StatementTag.class};
        SourceSectionFilter filter = SourceSectionFilter.newBuilder().sourceIs(new Source[]{source}).tagIs(exprTags).build();
        env.getInstrumenter().attachLoadSourceSectionListener(filter, (LoadSourceSectionListener)sectionsBefore, true).dispose();
        return sectionsBefore.getNearestNode();
    }

    private static NearestNode findNearestNodeOneBased(int oneBasedLineNumber, int column, Source source, TruffleInstrument.Env env) {
        NearestSections nearestSections = NearestSectionsFinder.findNearestSections(source, env, oneBasedLineNumber, column, false, StandardTags.ExpressionTag.class, StandardTags.StatementTag.class, StandardTags.RootTag.class);
        SourceSection containsSection = nearestSections.getContainsSourceSection();
        NearestNode nearestNode = containsSection == null ? new NearestNode(null, null, null) : (NearestSectionsFinder.isEndOfSectionMatchingCaretPosition(oneBasedLineNumber, column, containsSection) ? nearestSections.getContainsNode(true) : (NearestSectionsFinder.nodeIsInChildHierarchyOf(nearestSections.nextNode, nearestSections.containsNode) ? nearestSections.getNextNode() : (NearestSectionsFinder.nodeIsInChildHierarchyOf(nearestSections.previousNode, nearestSections.containsNode) ? nearestSections.getPreviousNode() : nearestSections.getContainsNode(false))));
        return nearestNode;
    }

    private static boolean isEndOfSectionMatchingCaretPosition(int line, int character, SourceSection section) {
        return section.getEndLine() == line && section.getEndColumn() == character;
    }

    private static boolean nodeIsInChildHierarchyOf(Node node, Node potentialParent) {
        if (node == null) {
            return false;
        }
        for (Node parent = node.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.equals(potentialParent)) continue;
            return true;
        }
        return false;
    }

    public static NearestSections findNearestSections(Source source, TruffleInstrument.Env env, int oneBasedLineNumber, int column, boolean instrumentableNodesOnly, Class<?> ... tags) {
        return NearestSectionsFinder.findNearestSections(source, env, SourceUtils.convertLineAndColumnToOffset(source, oneBasedLineNumber, column), instrumentableNodesOnly, tags);
    }

    protected static NearestSections findNearestSections(Source source, TruffleInstrument.Env env, int offset, boolean instrumentableNodesOnly, Class<?> ... tags) {
        NearestSections sectionsCollector = new NearestSections(offset, instrumentableNodesOnly);
        SourceSectionFilter.Builder filter = SourceSectionFilter.newBuilder().sourceIs(new Source[]{source});
        if (tags.length > 0) {
            filter.tagIs((Class[])tags);
        }
        env.getInstrumenter().attachLoadSourceSectionListener(filter.build(), (LoadSourceSectionListener)sectionsCollector, true).dispose();
        return sectionsCollector;
    }

    public static final class NearestSections
    implements LoadSourceSectionListener {
        private final int offset;
        private final boolean checkInstrumentable;
        private SourceSection containsMatch;
        private Node containsNode;
        private SourceSection previousMatch;
        private Node previousNode;
        private SourceSection nextMatch;
        private Node nextNode;

        NearestSections(int offset, boolean checkInstrumentable) {
            this.offset = offset;
            this.checkInstrumentable = checkInstrumentable;
        }

        public void onLoad(LoadSourceSectionEvent event) {
            Node eventNode = event.getNode();
            if (!(!this.checkInstrumentable || eventNode instanceof InstrumentableNode && ((InstrumentableNode)eventNode).isInstrumentable())) {
                return;
            }
            SourceSection sourceSection = event.getSourceSection();
            int o1 = sourceSection.getCharIndex();
            int o2 = sourceSection.getCharLength() > 0 ? sourceSection.getCharEndIndex() - 1 : sourceSection.getCharIndex();
            this.findOffsetApproximation(eventNode, sourceSection, o1, o2);
        }

        private void findOffsetApproximation(Node node, SourceSection sourceSection, int o1, int o2) {
            if (o1 <= this.offset && this.offset <= o2) {
                if (this.containsMatch == null || this.containsMatch.getCharLength() > sourceSection.getCharLength()) {
                    this.containsMatch = sourceSection;
                    this.containsNode = node;
                }
            } else if (o2 < this.offset) {
                if (this.previousMatch == null || this.previousMatch.getCharEndIndex() < sourceSection.getCharEndIndex() || this.previousMatch.getCharEndIndex() == sourceSection.getCharEndIndex() && this.previousMatch.getCharLength() < sourceSection.getCharLength()) {
                    this.previousMatch = sourceSection;
                    this.previousNode = node;
                }
            } else {
                assert (this.offset < o1);
                if (this.nextMatch == null || this.nextMatch.getCharIndex() > sourceSection.getCharIndex() || this.nextMatch.getCharIndex() == sourceSection.getCharIndex() && this.nextMatch.getCharLength() < sourceSection.getCharLength()) {
                    this.nextMatch = sourceSection;
                    this.nextNode = node;
                }
            }
        }

        public NearestNode getContainsNode(boolean containsEnd) {
            return new NearestNode(this.containsNode, this.containsMatch, containsEnd ? NodeLocationType.CONTAINS_END : NodeLocationType.CONTAINS);
        }

        public NearestNode getPreviousNode() {
            return new NearestNode(this.previousNode, this.previousMatch, NodeLocationType.PREVIOUS);
        }

        public NearestNode getNextNode() {
            return new NearestNode(this.nextNode, this.nextMatch, NodeLocationType.NEXT);
        }

        public InstrumentableNode getInstrumentableContainsNode() {
            return (InstrumentableNode)this.containsNode;
        }

        public InstrumentableNode getInstrumentablePreviousNode() {
            return (InstrumentableNode)this.previousNode;
        }

        public InstrumentableNode getInstrumentableNextNode() {
            return (InstrumentableNode)this.nextNode;
        }

        public SourceSection getContainsSourceSection() {
            return this.containsNode != null ? this.containsNode.getSourceSection() : null;
        }

        public SourceSection getPreviousSourceSection() {
            return this.previousNode != null ? this.previousNode.getSourceSection() : null;
        }

        public SourceSection getNextSourceSection() {
            return this.nextNode != null ? this.nextNode.getSourceSection() : null;
        }
    }

    private static final class SectionsBefore
    implements LoadSourceSectionListener {
        private final int line;
        private final int column;
        private SourceSection closestBefore;
        private Node node;
        private boolean hasExpression;

        SectionsBefore(int line, int column) {
            this.line = line;
            this.column = column;
        }

        public void onLoad(LoadSourceSectionEvent event) {
            SourceSection sourceSection = event.getSourceSection();
            if (sourceSection.getEndLine() > this.line || sourceSection.getEndLine() == this.line && sourceSection.getEndColumn() > this.column) {
                return;
            }
            if (this.closestBefore == null || sourceSection.getEndLine() > this.closestBefore.getEndLine()) {
                this.closestBefore = sourceSection;
                this.node = event.getNode();
                this.hasExpression = SectionsBefore.isExpression(event);
            } else if (sourceSection.getEndLine() == this.closestBefore.getEndLine() && (sourceSection.getEndColumn() > this.closestBefore.getEndColumn() || sourceSection.getEndColumn() == this.closestBefore.getEndColumn() && sourceSection.getCharLength() > this.closestBefore.getCharLength())) {
                boolean isExpression = SectionsBefore.isExpression(event);
                if (!this.hasExpression || isExpression) {
                    this.closestBefore = sourceSection;
                    this.node = event.getNode();
                    this.hasExpression = isExpression;
                }
            }
            if (this.closestBefore == null) {
                this.closestBefore = sourceSection;
                this.node = event.getNode();
                this.hasExpression = SectionsBefore.isExpression(event);
            } else {
                boolean sameColumn;
                boolean sameLine = sourceSection.getEndLine() == this.closestBefore.getEndLine();
                boolean bl = sameColumn = sourceSection.getEndColumn() == this.closestBefore.getEndColumn();
                if (sourceSection.getEndLine() > this.closestBefore.getEndLine() || sameLine && sourceSection.getEndColumn() >= this.closestBefore.getEndColumn()) {
                    boolean isExpression = SectionsBefore.isExpression(event);
                    if (!(this.hasExpression && !isExpression || sameLine && sameColumn && (!this.hasExpression || sourceSection.getCharLength() <= this.closestBefore.getCharLength()) && (this.hasExpression || SectionsBefore.isStatement(event)))) {
                        this.closestBefore = sourceSection;
                        this.node = event.getNode();
                        this.hasExpression = isExpression;
                    }
                }
            }
        }

        private static boolean isExpression(LoadSourceSectionEvent event) {
            InstrumentableNode inode = (InstrumentableNode)event.getNode();
            return inode.hasTag(StandardTags.ExpressionTag.class);
        }

        private static boolean isStatement(LoadSourceSectionEvent event) {
            InstrumentableNode inode = (InstrumentableNode)event.getNode();
            return inode.hasTag(StandardTags.StatementTag.class);
        }

        NearestNode getNearestNode() {
            NodeLocationType type = this.closestBefore.getEndLine() == this.line && this.closestBefore.getEndColumn() == this.column ? NodeLocationType.CONTAINS_END : NodeLocationType.PREVIOUS;
            return new NearestNode(this.node, this.closestBefore, type);
        }
    }

    public static enum NodeLocationType {
        CONTAINS,
        CONTAINS_END,
        PREVIOUS,
        NEXT,
        ROOT;

    }
}

