/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.utils;

import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import java.util.logging.Level;

public final class InteropUtils {
    private static final InteropLibrary INTEROP = (InteropLibrary)InteropLibrary.getFactory().getUncached();

    private InteropUtils() {
        assert (false);
    }

    public static Integer getNumberOfArguments(Object nodeObject, TruffleLogger logger) {
        if (nodeObject instanceof TruffleObject && INTEROP.isMemberReadable(nodeObject, "numberOfArguments")) {
            try {
                Object object = INTEROP.readMember(nodeObject, "numberOfArguments");
                return object instanceof Number ? Integer.valueOf(((Number)object).intValue()) : null;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                logger.log(Level.INFO, nodeObject.toString(), t);
            }
        }
        return null;
    }

    public static boolean isPrimitive(Object object) {
        Class<?> clazz = object.getClass();
        return clazz == Byte.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class || clazz == Float.class || clazz == Double.class || clazz == Character.class || clazz == Boolean.class || clazz == String.class;
    }

    public static VariableInfo[] getNodeObjectVariables(InstrumentableNode node) {
        Object nodeObject = node.getNodeObject();
        if (nodeObject == null) {
            return VariableInfo.EMPTY;
        }
        try {
            if (node.hasTag(StandardTags.ReadVariableTag.class) && INTEROP.isMemberReadable(nodeObject, "readVariableName")) {
                return InteropUtils.getNodeObjectVariables(node, INTEROP.readMember(nodeObject, "readVariableName"));
            }
            if (node.hasTag(StandardTags.WriteVariableTag.class) && INTEROP.isMemberReadable(nodeObject, "writeVariableName")) {
                return InteropUtils.getNodeObjectVariables(node, INTEROP.readMember(nodeObject, "writeVariableName"));
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (InteropException ex) {
            throw new AssertionError("Unexpected interop exception", ex);
        }
        return VariableInfo.EMPTY;
    }

    private static VariableInfo[] getNodeObjectVariables(InstrumentableNode node, Object namesObject) throws UnsupportedMessageException, InvalidArrayIndexException {
        if (INTEROP.hasArrayElements(namesObject)) {
            int size = (int)INTEROP.getArraySize(namesObject);
            VariableInfo[] infos = new VariableInfo[size];
            for (int i = 0; i < size; ++i) {
                Object element = INTEROP.readArrayElement(namesObject, (long)i);
                infos[i] = new VariableInfo(node, element);
            }
            return infos;
        }
        return new VariableInfo[]{new VariableInfo(node, namesObject)};
    }

    public static final class VariableInfo {
        private static final VariableInfo[] EMPTY = new VariableInfo[0];
        private final InstrumentableNode node;
        private final Object nameObject;
        private final String name;

        VariableInfo(InstrumentableNode node, Object nameObject) throws UnsupportedMessageException {
            this.node = node;
            this.nameObject = nameObject;
            assert (INTEROP.isString(nameObject));
            this.name = INTEROP.asString(nameObject);
        }

        public String getName() {
            return this.name;
        }

        public SourceSection getSourceSection() {
            if (INTEROP.hasSourceLocation(this.nameObject)) {
                try {
                    return INTEROP.getSourceLocation(this.nameObject);
                }
                catch (UnsupportedMessageException unsupportedMessageException) {
                    // empty catch block
                }
            }
            return ((Node)this.node).getSourceSection();
        }
    }
}

