/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.MarkupContent;
import org.graalvm.tools.lsp.server.types.ParameterInformation;

public class SignatureInformation
extends JSONBase {
    SignatureInformation(JSONObject jsonData) {
        super(jsonData);
    }

    public String getLabel() {
        return this.jsonData.getString("label");
    }

    public SignatureInformation setLabel(String label) {
        this.jsonData.put("label", label);
        return this;
    }

    public Object getDocumentation() {
        Object obj = this.jsonData.opt("documentation");
        if (obj instanceof JSONObject) {
            return new MarkupContent((JSONObject)obj);
        }
        return obj;
    }

    public SignatureInformation setDocumentation(Object documentation) {
        if (documentation instanceof MarkupContent) {
            this.jsonData.put("documentation", ((MarkupContent)documentation).jsonData);
        } else {
            this.jsonData.put("documentation", documentation);
        }
        return this;
    }

    public List<ParameterInformation> getParameters() {
        JSONArray json = this.jsonData.optJSONArray("parameters");
        if (json == null) {
            return null;
        }
        ArrayList<ParameterInformation> list = new ArrayList<ParameterInformation>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(new ParameterInformation(json.getJSONObject(i)));
        }
        return Collections.unmodifiableList(list);
    }

    public SignatureInformation setParameters(List<ParameterInformation> parameters) {
        if (parameters != null) {
            JSONArray json = new JSONArray();
            for (ParameterInformation parameterInformation : parameters) {
                json.put(parameterInformation.jsonData);
            }
            this.jsonData.put("parameters", json);
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SignatureInformation other = (SignatureInformation)obj;
        if (!Objects.equals(this.getLabel(), other.getLabel())) {
            return false;
        }
        if (!Objects.equals(this.getDocumentation(), other.getDocumentation())) {
            return false;
        }
        return Objects.equals(this.getParameters(), other.getParameters());
    }

    public int hashCode() {
        int hash = 5;
        hash = 79 * hash + Objects.hashCode(this.getLabel());
        if (this.getDocumentation() != null) {
            hash = 79 * hash + Objects.hashCode(this.getDocumentation());
        }
        if (this.getParameters() != null) {
            hash = 79 * hash + Objects.hashCode(this.getParameters());
        }
        return hash;
    }

    public static SignatureInformation create(String label, String documentation, ParameterInformation ... parameters) {
        JSONObject json = new JSONObject();
        json.put("label", label);
        json.putOpt("documentation", documentation);
        if (parameters != null) {
            JSONArray parametersJsonArr = new JSONArray();
            for (ParameterInformation parameterInformation : parameters) {
                parametersJsonArr.put(parameterInformation.jsonData);
            }
            json.put("parameters", parametersJsonArr);
        }
        return new SignatureInformation(json);
    }
}

