/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.JSONBase;

public class ResponseErrorLiteral
extends JSONBase {
    ResponseErrorLiteral(JSONObject jsonData) {
        super(jsonData);
    }

    public int getCode() {
        return this.jsonData.getInt("code");
    }

    public ResponseErrorLiteral setCode(int code) {
        this.jsonData.put("code", code);
        return this;
    }

    public String getMessage() {
        return this.jsonData.getString("message");
    }

    public ResponseErrorLiteral setMessage(String message) {
        this.jsonData.put("message", message);
        return this;
    }

    public Object getData() {
        return this.jsonData.opt("data");
    }

    public ResponseErrorLiteral setData(Object data) {
        this.jsonData.putOpt("data", data);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResponseErrorLiteral other = (ResponseErrorLiteral)obj;
        if (this.getCode() != other.getCode()) {
            return false;
        }
        if (!Objects.equals(this.getMessage(), other.getMessage())) {
            return false;
        }
        return Objects.equals(this.getData(), other.getData());
    }

    public int hashCode() {
        int hash = 5;
        hash = 83 * hash + Integer.hashCode(this.getCode());
        hash = 83 * hash + Objects.hashCode(this.getMessage());
        if (this.getData() != null) {
            hash = 83 * hash + Objects.hashCode(this.getData());
        }
        return hash;
    }

    public static ResponseErrorLiteral create(Integer code, String message) {
        JSONObject json = new JSONObject();
        json.put("code", code);
        json.put("message", message);
        return new ResponseErrorLiteral(json);
    }
}

