/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.Position;
import org.graalvm.tools.lsp.server.types.TextDocumentIdentifier;
import org.graalvm.tools.lsp.server.types.WorkDoneProgressParams;

public class RenameParams
extends WorkDoneProgressParams {
    RenameParams(JSONObject jsonData) {
        super(jsonData);
    }

    public TextDocumentIdentifier getTextDocument() {
        return new TextDocumentIdentifier(this.jsonData.getJSONObject("textDocument"));
    }

    public RenameParams setTextDocument(TextDocumentIdentifier textDocument) {
        this.jsonData.put("textDocument", textDocument.jsonData);
        return this;
    }

    public Position getPosition() {
        return new Position(this.jsonData.getJSONObject("position"));
    }

    public RenameParams setPosition(Position position) {
        this.jsonData.put("position", position.jsonData);
        return this;
    }

    public String getNewName() {
        return this.jsonData.getString("newName");
    }

    public RenameParams setNewName(String newName) {
        this.jsonData.put("newName", newName);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RenameParams other = (RenameParams)obj;
        if (!Objects.equals(this.getTextDocument(), other.getTextDocument())) {
            return false;
        }
        if (!Objects.equals(this.getPosition(), other.getPosition())) {
            return false;
        }
        if (!Objects.equals(this.getNewName(), other.getNewName())) {
            return false;
        }
        return Objects.equals(this.getWorkDoneToken(), other.getWorkDoneToken());
    }

    @Override
    public int hashCode() {
        int hash = 2;
        hash = 43 * hash + Objects.hashCode(this.getTextDocument());
        hash = 43 * hash + Objects.hashCode(this.getPosition());
        hash = 43 * hash + Objects.hashCode(this.getNewName());
        if (this.getWorkDoneToken() != null) {
            hash = 43 * hash + Objects.hashCode(this.getWorkDoneToken());
        }
        return hash;
    }

    public static RenameParams create(TextDocumentIdentifier textDocument, Position position, String newName) {
        JSONObject json = new JSONObject();
        json.put("textDocument", textDocument.jsonData);
        json.put("position", position.jsonData);
        json.put("newName", newName);
        return new RenameParams(json);
    }
}

