/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.Position;

public class Range
extends JSONBase {
    Range(JSONObject jsonData) {
        super(jsonData);
    }

    public Position getStart() {
        return new Position(this.jsonData.getJSONObject("start"));
    }

    public Range setStart(Position start) {
        this.jsonData.put("start", start.jsonData);
        return this;
    }

    public Position getEnd() {
        return new Position(this.jsonData.getJSONObject("end"));
    }

    public Range setEnd(Position end) {
        this.jsonData.put("end", end.jsonData);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Range other = (Range)obj;
        if (!Objects.equals(this.getStart(), other.getStart())) {
            return false;
        }
        return Objects.equals(this.getEnd(), other.getEnd());
    }

    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + Objects.hashCode(this.getStart());
        hash = 23 * hash + Objects.hashCode(this.getEnd());
        return hash;
    }

    public static Range create(Position start, Position end) {
        JSONObject json = new JSONObject();
        json.put("start", start.jsonData);
        json.put("end", end.jsonData);
        return new Range(json);
    }

    public static Range create(Integer startLine, Integer startCharacter, Integer endLine, Integer endCharacter) {
        return Range.create(Position.create(startLine, startCharacter), Position.create(endLine, endCharacter));
    }

    public static Range create(Object one, Object two, Integer three, Integer four) {
        if (one instanceof Integer && two instanceof Integer && three != null && four != null) {
            return Range.create((Integer)one, (Integer)two, three, four);
        }
        if (one instanceof Position && two instanceof Position) {
            return Range.create((Position)one, (Position)two);
        }
        throw new IllegalArgumentException("Range.create called with invalid arguments");
    }
}

