/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.FormattingOptions;
import org.graalvm.tools.lsp.server.types.Range;
import org.graalvm.tools.lsp.server.types.TextDocumentIdentifier;
import org.graalvm.tools.lsp.server.types.WorkDoneProgressParams;

public class DocumentRangeFormattingParams
extends WorkDoneProgressParams {
    DocumentRangeFormattingParams(JSONObject jsonData) {
        super(jsonData);
    }

    public TextDocumentIdentifier getTextDocument() {
        return new TextDocumentIdentifier(this.jsonData.getJSONObject("textDocument"));
    }

    public DocumentRangeFormattingParams setTextDocument(TextDocumentIdentifier textDocument) {
        this.jsonData.put("textDocument", textDocument.jsonData);
        return this;
    }

    public Range getRange() {
        return new Range(this.jsonData.getJSONObject("range"));
    }

    public DocumentRangeFormattingParams setRange(Range range) {
        this.jsonData.put("range", range.jsonData);
        return this;
    }

    public FormattingOptions getOptions() {
        return new FormattingOptions(this.jsonData.getJSONObject("options"));
    }

    public DocumentRangeFormattingParams setOptions(FormattingOptions options) {
        this.jsonData.put("options", options.jsonData);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DocumentRangeFormattingParams other = (DocumentRangeFormattingParams)obj;
        if (!Objects.equals(this.getTextDocument(), other.getTextDocument())) {
            return false;
        }
        if (!Objects.equals(this.getRange(), other.getRange())) {
            return false;
        }
        if (!Objects.equals(this.getOptions(), other.getOptions())) {
            return false;
        }
        return Objects.equals(this.getWorkDoneToken(), other.getWorkDoneToken());
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 73 * hash + Objects.hashCode(this.getTextDocument());
        hash = 73 * hash + Objects.hashCode(this.getRange());
        hash = 73 * hash + Objects.hashCode(this.getOptions());
        if (this.getWorkDoneToken() != null) {
            hash = 73 * hash + Objects.hashCode(this.getWorkDoneToken());
        }
        return hash;
    }

    public static DocumentRangeFormattingParams create(TextDocumentIdentifier textDocument, Range range, FormattingOptions options) {
        JSONObject json = new JSONObject();
        json.put("textDocument", textDocument.jsonData);
        json.put("range", range.jsonData);
        json.put("options", options.jsonData);
        return new DocumentRangeFormattingParams(json);
    }
}

