/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.ConfigurationItem;
import org.graalvm.tools.lsp.server.types.JSONBase;

public class ConfigurationParams
extends JSONBase {
    ConfigurationParams(JSONObject jsonData) {
        super(jsonData);
    }

    public List<ConfigurationItem> getItems() {
        JSONArray json = this.jsonData.getJSONArray("items");
        ArrayList<ConfigurationItem> list = new ArrayList<ConfigurationItem>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(new ConfigurationItem(json.getJSONObject(i)));
        }
        return Collections.unmodifiableList(list);
    }

    public ConfigurationParams setItems(List<ConfigurationItem> items) {
        JSONArray json = new JSONArray();
        for (ConfigurationItem configurationItem : items) {
            json.put(configurationItem.jsonData);
        }
        this.jsonData.put("items", json);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigurationParams other = (ConfigurationParams)obj;
        return Objects.equals(this.getItems(), other.getItems());
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + Objects.hashCode(this.getItems());
        return hash;
    }

    public static ConfigurationParams create(List<ConfigurationItem> items) {
        JSONObject json = new JSONObject();
        JSONArray itemsJsonArr = new JSONArray();
        for (ConfigurationItem configurationItem : items) {
            itemsJsonArr.put(configurationItem.jsonData);
        }
        json.put("items", itemsJsonArr);
        return new ConfigurationParams(json);
    }
}

