/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.CompletionItem;
import org.graalvm.tools.lsp.server.types.JSONBase;

public class CompletionList
extends JSONBase {
    CompletionList(JSONObject jsonData) {
        super(jsonData);
    }

    public boolean isIncomplete() {
        return this.jsonData.getBoolean("isIncomplete");
    }

    public CompletionList setIncomplete(boolean isIncomplete) {
        this.jsonData.put("isIncomplete", isIncomplete);
        return this;
    }

    public List<CompletionItem> getItems() {
        JSONArray json = this.jsonData.getJSONArray("items");
        ArrayList<CompletionItem> list = new ArrayList<CompletionItem>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(new CompletionItem(json.getJSONObject(i)));
        }
        return Collections.unmodifiableList(list);
    }

    public CompletionList setItems(List<CompletionItem> items) {
        JSONArray json = new JSONArray();
        for (CompletionItem completionItem : items) {
            json.put(completionItem.jsonData);
        }
        this.jsonData.put("items", json);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompletionList other = (CompletionList)obj;
        if (this.isIncomplete() != other.isIncomplete()) {
            return false;
        }
        return Objects.equals(this.getItems(), other.getItems());
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + Boolean.hashCode(this.isIncomplete());
        hash = 59 * hash + Objects.hashCode(this.getItems());
        return hash;
    }

    public static CompletionList create(List<CompletionItem> items, boolean isIncomplete) {
        JSONObject json = new JSONObject();
        json.put("isIncomplete", isIncomplete);
        JSONArray itemsJsonArr = new JSONArray();
        for (CompletionItem completionItem : items) {
            itemsJsonArr.put(completionItem.jsonData);
        }
        json.put("items", itemsJsonArr);
        return new CompletionList(json);
    }
}

