/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import java.util.HashMap;
import java.util.Map;

public enum CodeActionKind {
    Empty(""),
    QuickFix("quickfix"),
    Refactor("refactor"),
    RefactorExtract("refactor.extract"),
    RefactorInline("refactor.inline"),
    RefactorRewrite("refactor.rewrite"),
    Source("source"),
    SourceOrganizeImports("source.organizeImports"),
    SourceFixAll("source.fixAll");

    private final String stringValue;
    private static final Map<String, CodeActionKind> lookup;

    private CodeActionKind(String stringValue) {
        this.stringValue = stringValue;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public static CodeActionKind get(String stringValue) {
        return lookup.get(stringValue);
    }

    static {
        lookup = new HashMap<String, CodeActionKind>();
        for (CodeActionKind value : CodeActionKind.values()) {
            lookup.put(value.getStringValue(), value);
        }
    }
}

