/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.request;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeVisitor;
import com.oracle.truffle.api.source.SourceSection;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.graalvm.tools.lsp.server.ContextAwareExecutor;
import org.graalvm.tools.lsp.server.request.AbstractRequestHandler;
import org.graalvm.tools.lsp.server.types.DocumentHighlight;
import org.graalvm.tools.lsp.server.types.DocumentHighlightKind;
import org.graalvm.tools.lsp.server.types.Range;
import org.graalvm.tools.lsp.server.utils.InteropUtils;
import org.graalvm.tools.lsp.server.utils.SourceUtils;
import org.graalvm.tools.lsp.server.utils.TextDocumentSurrogate;
import org.graalvm.tools.lsp.server.utils.TextDocumentSurrogateMap;

public final class HighlightRequestHandler
extends AbstractRequestHandler {
    public HighlightRequestHandler(TruffleInstrument.Env envMain, TruffleInstrument.Env env, TextDocumentSurrogateMap surrogateMap, ContextAwareExecutor executor) {
        super(envMain, env, surrogateMap, executor);
    }

    public List<? extends DocumentHighlight> highlightWithEnteredContext(URI uri, int line, int character) {
        TextDocumentSurrogate surrogate = this.surrogateMap.get(uri);
        InstrumentableNode nodeAtCaret = this.findNodeAtCaret(surrogate, line, character, new Class[0]);
        if (nodeAtCaret != null && (nodeAtCaret.hasTag(StandardTags.ReadVariableTag.class) || nodeAtCaret.hasTag(StandardTags.WriteVariableTag.class))) {
            return this.findOtherReadOrWrites(surrogate, nodeAtCaret, line, character);
        }
        return Collections.emptyList();
    }

    List<? extends DocumentHighlight> findOtherReadOrWrites(TextDocumentSurrogate surrogate, InstrumentableNode nodeAtCaret, int line, int character) {
        InteropUtils.VariableInfo[] caretVariables = InteropUtils.getNodeObjectVariables(nodeAtCaret);
        if (caretVariables.length > 0) {
            HashSet<String> variableNames = new HashSet<String>();
            for (InteropUtils.VariableInfo varInfo : caretVariables) {
                if (!HighlightRequestHandler.contains(varInfo.getSourceSection(), line, character)) continue;
                variableNames.add(varInfo.getName());
            }
            Object scope = HighlightRequestHandler.getScope(surrogate, nodeAtCaret);
            ArrayList<DocumentHighlight> highlights = new ArrayList<DocumentHighlight>();
            while (scope != null) {
                InteropLibrary interop = InteropLibrary.getUncached((Object)scope);
                if (interop.hasSourceLocation(scope)) {
                    try {
                        SourceSection sourceLocation = interop.getSourceLocation(scope);
                        Node[] nodeLocation = new Node[]{null};
                        EventBinding binding = this.env.getInstrumenter().attachLoadSourceSectionListener(SourceSectionFilter.newBuilder().sourceSectionEquals(new SourceSection[]{sourceLocation}).build(), e -> {
                            Node node = e.getNode();
                            if (nodeLocation[0] == null || HighlightRequestHandler.isParent(node, nodeLocation[0])) {
                                nodeLocation[0] = node;
                            }
                        }, true);
                        binding.dispose();
                        this.addHighlights(nodeLocation[0], variableNames, highlights);
                    }
                    catch (UnsupportedMessageException e2) {
                        throw CompilerDirectives.shouldNotReachHere((Throwable)e2);
                    }
                }
                if (interop.hasScopeParent(scope)) {
                    try {
                        scope = interop.getScopeParent(scope);
                        continue;
                    }
                    catch (UnsupportedMessageException e3) {
                        throw CompilerDirectives.shouldNotReachHere((Throwable)e3);
                    }
                }
                scope = null;
            }
            return highlights;
        }
        return Collections.emptyList();
    }

    private static boolean isParent(Node candidate, Node child) {
        for (Node parent = child.getParent(); parent != null; parent = parent.getParent()) {
            if (parent != candidate) continue;
            return true;
        }
        return false;
    }

    private static boolean contains(SourceSection sourceSection, int zeroBasedLineNumber, int zeroBasedColumnNumber) {
        int line = SourceUtils.zeroBasedLineToOneBasedLine(zeroBasedLineNumber, sourceSection.getSource());
        int column = SourceUtils.zeroBasedColumnToOneBasedColumn(zeroBasedLineNumber, line, zeroBasedColumnNumber, sourceSection.getSource());
        int startLine = sourceSection.getStartLine();
        int endLine = sourceSection.getEndLine();
        return (startLine < line || startLine == line && sourceSection.getStartColumn() <= column) && (line < endLine || line == endLine && column <= sourceSection.getEndColumn());
    }

    private void addHighlights(Node scopeRoot, final Set<String> variableNames, final List<DocumentHighlight> highlights) {
        if (scopeRoot != null) {
            scopeRoot.accept(new NodeVisitor(){

                public boolean visit(Node node) {
                    InstrumentableNode instrumentableNode;
                    if (node instanceof InstrumentableNode && ((instrumentableNode = (InstrumentableNode)node).hasTag(StandardTags.WriteVariableTag.class) || instrumentableNode.hasTag(StandardTags.ReadVariableTag.class))) {
                        InteropUtils.VariableInfo[] variables = InteropUtils.getNodeObjectVariables(instrumentableNode);
                        assert (variables.length > 0) : instrumentableNode.getClass().getCanonicalName() + ": " + instrumentableNode.toString();
                        for (InteropUtils.VariableInfo varInfo : variables) {
                            SourceSection sourceSection;
                            if (!variableNames.contains(varInfo.getName()) || !SourceUtils.isValidSourceSection(sourceSection = varInfo.getSourceSection(), HighlightRequestHandler.this.env.getOptions())) continue;
                            Range range = SourceUtils.sourceSectionToRange(sourceSection);
                            DocumentHighlightKind kind = instrumentableNode.hasTag(StandardTags.WriteVariableTag.class) ? DocumentHighlightKind.Write : DocumentHighlightKind.Read;
                            DocumentHighlight highlight = DocumentHighlight.create(range, kind);
                            highlights.add(highlight);
                        }
                    }
                    return true;
                }
            });
        }
    }
}

