/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.request;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.NodeLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.PrintWriter;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.graalvm.tools.lsp.server.ContextAwareExecutor;
import org.graalvm.tools.lsp.server.utils.CoverageData;
import org.graalvm.tools.lsp.server.utils.NearestSectionsFinder;
import org.graalvm.tools.lsp.server.utils.SourcePredicateBuilder;
import org.graalvm.tools.lsp.server.utils.SourceUtils;
import org.graalvm.tools.lsp.server.utils.SourceWrapper;
import org.graalvm.tools.lsp.server.utils.TextDocumentSurrogate;
import org.graalvm.tools.lsp.server.utils.TextDocumentSurrogateMap;

public abstract class AbstractRequestHandler {
    protected final TruffleInstrument.Env env;
    protected final TextDocumentSurrogateMap surrogateMap;
    protected final PrintWriter err;
    protected final ContextAwareExecutor contextAwareExecutor;
    protected final TruffleLogger logger;

    AbstractRequestHandler(TruffleInstrument.Env mainEnv, TruffleInstrument.Env env, TextDocumentSurrogateMap surrogateMap, ContextAwareExecutor contextAwareExecutor) {
        this.env = env;
        this.err = new PrintWriter(mainEnv.err(), true);
        this.surrogateMap = surrogateMap;
        this.contextAwareExecutor = contextAwareExecutor;
        this.logger = mainEnv.getLogger("");
    }

    public final InstrumentableNode findNodeAtCaret(TextDocumentSurrogate surrogate, int line, int character, Class<?> ... tag) {
        Source source;
        SourceWrapper sourceWrapper;
        if (surrogate != null && (sourceWrapper = surrogate.getSourceWrapper()).isParsingSuccessful() && SourceUtils.isLineValid(line, source = sourceWrapper.getSource())) {
            SourceSection nextNodeSection;
            int oneBasedColumn;
            int oneBasedLineNumber = SourceUtils.zeroBasedLineToOneBasedLine(line, source);
            NearestSectionsFinder.NearestSections nearestSections = NearestSectionsFinder.findNearestSections(source, this.env, oneBasedLineNumber, oneBasedColumn = SourceUtils.zeroBasedColumnToOneBasedColumn(line, oneBasedLineNumber, character, source), true, tag);
            if (nearestSections.getNextSourceSection() != null && (nextNodeSection = nearestSections.getNextSourceSection()).getStartLine() == oneBasedLineNumber && nextNodeSection.getStartColumn() == oneBasedColumn) {
                return nearestSections.getInstrumentableNextNode();
            }
            return nearestSections.getInstrumentableContainsNode();
        }
        return null;
    }

    protected final <T> T getFutureResultOrHandleExceptions(Future<T> future) {
        try {
            return future.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            InteropLibrary interopLib = InteropLibrary.getUncached();
            if (cause != null && interopLib.isException((Object)cause)) {
                try {
                    throw interopLib.throwException((Object)cause);
                }
                catch (UnsupportedMessageException ume) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)ume);
                }
            }
            e.printStackTrace(this.err);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    protected static Object getScope(TextDocumentSurrogate surrogate, InstrumentableNode node) {
        NodeLibrary nodeLibrary;
        CoverageData data;
        List<CoverageData> coverageData = surrogate.getCoverageData(((Node)node).getSourceSection());
        MaterializedFrame frame = null;
        if (coverageData != null && (data = (CoverageData)coverageData.stream().findFirst().orElse(null)) != null) {
            frame = data.getFrame();
        }
        if ((nodeLibrary = NodeLibrary.getUncached((Object)node)).hasScope((Object)node, frame)) {
            try {
                return nodeLibrary.getScope((Object)node, (Frame)frame, true);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }
        return null;
    }

    protected final SourcePredicateBuilder newDefaultSourcePredicateBuilder() {
        return SourcePredicateBuilder.newBuilder().excludeInternal(this.env.getOptions()).newestSource(this.surrogateMap);
    }
}

