/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.graalvm.collections.Pair;
import org.graalvm.tools.api.lsp.LSPServerAccessor;
import org.graalvm.tools.lsp.exceptions.DiagnosticsNotification;
import org.graalvm.tools.lsp.exceptions.UnknownLanguageException;
import org.graalvm.tools.lsp.server.DelegateServers;
import org.graalvm.tools.lsp.server.TruffleAdapter;
import org.graalvm.tools.lsp.server.types.CodeAction;
import org.graalvm.tools.lsp.server.types.CodeActionParams;
import org.graalvm.tools.lsp.server.types.CodeLens;
import org.graalvm.tools.lsp.server.types.CodeLensOptions;
import org.graalvm.tools.lsp.server.types.CodeLensParams;
import org.graalvm.tools.lsp.server.types.CompletionItem;
import org.graalvm.tools.lsp.server.types.CompletionList;
import org.graalvm.tools.lsp.server.types.CompletionOptions;
import org.graalvm.tools.lsp.server.types.CompletionParams;
import org.graalvm.tools.lsp.server.types.Coverage;
import org.graalvm.tools.lsp.server.types.DidChangeTextDocumentParams;
import org.graalvm.tools.lsp.server.types.DidCloseTextDocumentParams;
import org.graalvm.tools.lsp.server.types.DidOpenTextDocumentParams;
import org.graalvm.tools.lsp.server.types.DidSaveTextDocumentParams;
import org.graalvm.tools.lsp.server.types.DocumentFormattingParams;
import org.graalvm.tools.lsp.server.types.DocumentHighlight;
import org.graalvm.tools.lsp.server.types.DocumentOnTypeFormattingParams;
import org.graalvm.tools.lsp.server.types.DocumentRangeFormattingParams;
import org.graalvm.tools.lsp.server.types.DocumentSymbolParams;
import org.graalvm.tools.lsp.server.types.ExecuteCommandOptions;
import org.graalvm.tools.lsp.server.types.ExecuteCommandParams;
import org.graalvm.tools.lsp.server.types.Hover;
import org.graalvm.tools.lsp.server.types.InitializeParams;
import org.graalvm.tools.lsp.server.types.InitializeResult;
import org.graalvm.tools.lsp.server.types.LanguageClient;
import org.graalvm.tools.lsp.server.types.LanguageServer;
import org.graalvm.tools.lsp.server.types.Location;
import org.graalvm.tools.lsp.server.types.MessageType;
import org.graalvm.tools.lsp.server.types.PublishDiagnosticsParams;
import org.graalvm.tools.lsp.server.types.ReferenceParams;
import org.graalvm.tools.lsp.server.types.RenameParams;
import org.graalvm.tools.lsp.server.types.ServerCapabilities;
import org.graalvm.tools.lsp.server.types.ShowMessageParams;
import org.graalvm.tools.lsp.server.types.SignatureHelp;
import org.graalvm.tools.lsp.server.types.SignatureHelpOptions;
import org.graalvm.tools.lsp.server.types.SymbolInformation;
import org.graalvm.tools.lsp.server.types.TextDocumentContentChangeEvent;
import org.graalvm.tools.lsp.server.types.TextDocumentPositionParams;
import org.graalvm.tools.lsp.server.types.TextDocumentSyncKind;
import org.graalvm.tools.lsp.server.types.TextEdit;
import org.graalvm.tools.lsp.server.types.WorkspaceEdit;
import org.graalvm.tools.lsp.server.types.WorkspaceFolder;
import org.graalvm.tools.lsp.server.types.WorkspaceSymbolParams;
import org.graalvm.tools.lsp.server.utils.TextDocumentSurrogate;

public final class LanguageServerImpl
extends LanguageServer {
    private static final String DRY_RUN = "dry_run";
    private static final String GET_COVERAGE = "get_coverage";
    private static final TextDocumentSyncKind TEXT_DOCUMENT_SYNC_KIND = TextDocumentSyncKind.Incremental;
    private final TruffleAdapter truffleAdapter;
    private final PrintWriter err;
    private final PrintWriter info;
    private LanguageClient client;
    private final Map<URI, String> openedFileUri2LangId = new HashMap<URI, String>();
    private ExecutorService clientConnectionExecutor;
    private final Hover emptyHover = Hover.create(Collections.emptyList());
    private final SignatureHelp emptySignatureHelp = SignatureHelp.create(Collections.emptyList(), null, null);
    private ServerCapabilities serverCapabilities;

    private LanguageServerImpl(TruffleAdapter adapter, PrintWriter info, PrintWriter err) {
        this.truffleAdapter = adapter;
        this.info = info;
        this.err = err;
    }

    public static LanguageServerImpl create(TruffleAdapter adapter, PrintWriter info, PrintWriter err) {
        return new LanguageServerImpl(adapter, info, err);
    }

    @Override
    public CompletableFuture<InitializeResult> initialize(InitializeParams initializeParams) {
        ServerCapabilities capabilities = ServerCapabilities.create();
        capabilities.setTextDocumentSync((Object)TEXT_DOCUMENT_SYNC_KIND);
        capabilities.setDocumentSymbolProvider(false);
        capabilities.setWorkspaceSymbolProvider(false);
        capabilities.setDefinitionProvider(false);
        capabilities.setDocumentHighlightProvider(true);
        capabilities.setCodeLensProvider(CodeLensOptions.create().setResolveProvider(false));
        capabilities.setCompletionProvider(CompletionOptions.create().setResolveProvider(false));
        capabilities.setCodeActionProvider(true);
        capabilities.setSignatureHelpProvider(SignatureHelpOptions.create());
        capabilities.setHoverProvider(true);
        capabilities.setReferencesProvider(false);
        ArrayList<String> commands = new ArrayList<String>(this.truffleAdapter.getExtensionCommandNames());
        commands.add(DRY_RUN);
        commands.add(GET_COVERAGE);
        capabilities.setExecuteCommandProvider(ExecuteCommandOptions.create(commands));
        this.truffleAdapter.initializeLSPServer(new LSPServerAccessor(){

            public void sendCustomNotification(String method, Object params) {
                LanguageServerImpl.this.client.sendCustomNotification(method, params);
            }

            public Map<URI, String> getOpenFileURI2LangId() {
                return LanguageServerImpl.this.openedFileUri2LangId;
            }

            public Source getSource(URI uri) {
                return LanguageServerImpl.this.truffleAdapter.getSource(uri);
            }
        });
        this.serverCapabilities = capabilities;
        CompletableFuture.runAsync(() -> this.parseWorkspace(initializeParams.getWorkspaceFolders()));
        return CompletableFuture.completedFuture(InitializeResult.create(capabilities));
    }

    @Override
    protected boolean supportsMethod(String method, JSONObject params) {
        return DelegateServers.supportsMethod(method, params, this.serverCapabilities);
    }

    @Override
    public CompletableFuture<Object> shutdown() {
        this.info.println("[Graal LSP] Shutting down server...");
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public void exit() {
        this.clientConnectionExecutor.shutdown();
        this.info.println("[Graal LSP] Server shutdown done.");
    }

    @Override
    public void connect(LanguageClient client) {
        this.client = client;
    }

    @Override
    public CompletableFuture<CompletionList> completion(CompletionParams position) {
        Future<CompletionList> futureCompletionList = this.truffleAdapter.completion(URI.create(position.getTextDocument().getUri()), position.getPosition().getLine(), position.getPosition().getCharacter(), position.getContext());
        return CompletableFuture.supplyAsync(() -> this.waitForResultAndHandleExceptions(futureCompletionList, this.truffleAdapter.completionHandler.emptyList));
    }

    @Override
    public CompletableFuture<CompletionItem> resolveCompletion(CompletionItem unresolved) {
        return null;
    }

    @Override
    public CompletableFuture<Hover> hover(TextDocumentPositionParams position) {
        Future<Hover> futureHover = this.truffleAdapter.hover(URI.create(position.getTextDocument().getUri()), position.getPosition().getLine(), position.getPosition().getCharacter());
        return CompletableFuture.supplyAsync(() -> this.waitForResultAndHandleExceptions(futureHover, this.emptyHover));
    }

    @Override
    public CompletableFuture<SignatureHelp> signatureHelp(TextDocumentPositionParams position) {
        Future<SignatureHelp> future = this.truffleAdapter.signatureHelp(URI.create(position.getTextDocument().getUri()), position.getPosition().getLine(), position.getPosition().getCharacter());
        return CompletableFuture.supplyAsync(() -> this.waitForResultAndHandleExceptions(future, this.emptySignatureHelp));
    }

    @Override
    public CompletableFuture<List<? extends Location>> definition(TextDocumentPositionParams position) {
        return CompletableFuture.completedFuture(Collections.emptyList());
    }

    @Override
    public CompletableFuture<List<? extends Location>> references(ReferenceParams params) {
        return CompletableFuture.completedFuture(Collections.emptyList());
    }

    @Override
    public CompletableFuture<List<? extends DocumentHighlight>> documentHighlight(TextDocumentPositionParams position) {
        Future<List<? extends DocumentHighlight>> future = this.truffleAdapter.documentHighlight(URI.create(position.getTextDocument().getUri()), position.getPosition().getLine(), position.getPosition().getCharacter());
        Supplier<List> supplier = () -> this.waitForResultAndHandleExceptions(future, Collections.emptyList());
        return CompletableFuture.supplyAsync(supplier);
    }

    @Override
    public CompletableFuture<List<? extends SymbolInformation>> documentSymbol(DocumentSymbolParams params) {
        return CompletableFuture.completedFuture(Collections.emptyList());
    }

    @Override
    public CompletableFuture<List<? extends CodeAction>> codeAction(CodeActionParams params) {
        return CompletableFuture.completedFuture(Collections.emptyList());
    }

    @Override
    public CompletableFuture<List<? extends CodeLens>> codeLens(CodeLensParams params) {
        return CompletableFuture.completedFuture(Collections.emptyList());
    }

    @Override
    public CompletableFuture<CodeLens> resolveCodeLens(CodeLens unresolved) {
        return null;
    }

    @Override
    public CompletableFuture<List<? extends TextEdit>> formatting(DocumentFormattingParams params) {
        return null;
    }

    @Override
    public CompletableFuture<List<? extends TextEdit>> rangeFormatting(DocumentRangeFormattingParams params) {
        return null;
    }

    @Override
    public CompletableFuture<List<? extends TextEdit>> onTypeFormatting(DocumentOnTypeFormattingParams params) {
        return null;
    }

    @Override
    public CompletableFuture<WorkspaceEdit> rename(RenameParams params) {
        return null;
    }

    @Override
    public void didOpen(DidOpenTextDocumentParams params) {
        URI uri = URI.create(params.getTextDocument().getUri());
        if (!uri.getScheme().equals("file")) {
            this.client.showMessage(ShowMessageParams.create(MessageType.Error, "URI with schema other than 'file' are not supported yet. uri=" + uri.toString()));
            return;
        }
        this.openedFileUri2LangId.put(uri, params.getTextDocument().getLanguageId());
        Future<CallTarget> future = this.truffleAdapter.parse(params.getTextDocument().getText(), params.getTextDocument().getLanguageId(), uri);
        CompletableFuture.runAsync(() -> this.waitForResultAndHandleExceptions(future, null, uri));
    }

    @Override
    public void didChange(DidChangeTextDocumentParams params) {
        this.processChanges(params.getTextDocument().getUri(), params.getContentChanges());
    }

    private void processChanges(String documentUri, List<? extends TextDocumentContentChangeEvent> list) {
        Future<TextDocumentSurrogate> future;
        String langId = this.openedFileUri2LangId.get(URI.create(documentUri));
        if (langId == null) {
            this.truffleAdapter.getLogger().warning("Changed document that was not opened: " + documentUri);
            return;
        }
        URI uri = URI.create(documentUri);
        switch (TEXT_DOCUMENT_SYNC_KIND) {
            case Full: {
                TextDocumentContentChangeEvent e = list.iterator().next();
                future = this.truffleAdapter.parse(e.getText(), langId, uri);
                break;
            }
            case Incremental: {
                future = this.truffleAdapter.processChangesAndParse(list, uri);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown TextDocumentSyncKind: " + (Object)((Object)TEXT_DOCUMENT_SYNC_KIND));
            }
        }
        CompletableFuture.runAsync(() -> this.waitForResultAndHandleExceptions(future, null, uri));
    }

    @Override
    public void didClose(DidCloseTextDocumentParams params) {
        URI uri = URI.create(params.getTextDocument().getUri());
        this.openedFileUri2LangId.remove(uri);
        this.truffleAdapter.didClose(uri);
    }

    @Override
    public void didSave(DidSaveTextDocumentParams params) {
        Future<Object> future;
        URI uri = URI.create(params.getTextDocument().getUri());
        if (params.getText() != null) {
            String langId = this.openedFileUri2LangId.get(uri);
            if (langId == null) {
                this.truffleAdapter.getLogger().warning("Saved document that was not opened: " + uri);
                return;
            }
            future = this.truffleAdapter.parse(params.getText(), langId, uri);
        } else {
            future = this.truffleAdapter.reparse(uri);
        }
        CompletableFuture.runAsync(() -> this.waitForResultAndHandleExceptions(future, null, uri));
    }

    @Override
    public CompletableFuture<List<? extends SymbolInformation>> symbol(WorkspaceSymbolParams params) {
        return CompletableFuture.completedFuture(Collections.emptyList());
    }

    @Override
    public CompletableFuture<Object> executeCommand(ExecuteCommandParams params) {
        switch (params.getCommand()) {
            case "dry_run": {
                String uri = (String)params.getArguments().get(0);
                Future<Boolean> future = this.truffleAdapter.runCoverageAnalysis(URI.create(uri));
                return CompletableFuture.supplyAsync(() -> this.waitForResultAndHandleExceptions(future));
            }
            case "get_coverage": {
                String uri = (String)params.getArguments().get(0);
                Future<Coverage> futureCoverage = this.truffleAdapter.getCoverage(URI.create(uri));
                return CompletableFuture.supplyAsync(() -> this.waitForResultAndHandleExceptions(futureCoverage));
            }
        }
        Future<?> extensionCommand = this.truffleAdapter.createExtensionCommand(params);
        if (extensionCommand != null) {
            return CompletableFuture.supplyAsync(() -> this.waitForResultAndHandleExceptions(extensionCommand));
        }
        this.err.println("Unkown command: " + params.getCommand());
        return CompletableFuture.completedFuture(new Object());
    }

    @Override
    public LanguageServer.LoggerProxy getLogger() {
        return new LanguageServer.LoggerProxy(){

            @Override
            public boolean isLoggable(Level level) {
                return LanguageServerImpl.this.truffleAdapter.getLogger().isLoggable(level);
            }

            @Override
            public void log(Level level, String msg) {
                LanguageServerImpl.this.truffleAdapter.getLogger().log(level, msg);
            }

            @Override
            public void log(Level level, String msg, Throwable thrown) {
                LanguageServerImpl.this.truffleAdapter.getLogger().log(level, msg, thrown);
            }
        };
    }

    private void parseWorkspace(List<WorkspaceFolder> workspaces) {
        for (WorkspaceFolder workspace : workspaces) {
            List<Future<?>> parsingTasks = this.truffleAdapter.parseWorkspace(URI.create(workspace.getUri()));
            for (Future<?> future : parsingTasks) {
                this.waitForResultAndHandleExceptions(future);
            }
        }
    }

    private <T> T waitForResultAndHandleExceptions(Future<T> future) {
        return this.waitForResultAndHandleExceptions(future, null, null);
    }

    private <T> T waitForResultAndHandleExceptions(Future<T> future, T resultOnError) {
        return this.waitForResultAndHandleExceptions(future, resultOnError, null);
    }

    private <T> T waitForResultAndHandleExceptions(Future<T> future, T resultOnError, URI uriToClearDiagnostics) {
        try {
            T result = future.get();
            if (uriToClearDiagnostics != null) {
                this.client.publishDiagnostics(PublishDiagnosticsParams.create(uriToClearDiagnostics.toString(), Collections.emptyList()));
            }
            return result;
        }
        catch (InterruptedException e) {
            e.printStackTrace(this.err);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof UnknownLanguageException) {
                String message = "Unknown language: " + e.getCause().getMessage();
                this.truffleAdapter.getLogger().fine(message);
                this.client.showMessage(ShowMessageParams.create(MessageType.Error, message));
            }
            if (e.getCause() instanceof DiagnosticsNotification) {
                for (PublishDiagnosticsParams params : ((DiagnosticsNotification)e.getCause()).getDiagnosticParamsCollection()) {
                    this.client.publishDiagnostics(params);
                }
            }
            e.printStackTrace(this.err);
        }
        return resultOnError;
    }

    public CompletableFuture<?> start(final ServerSocket serverSocket, final List<Pair<String, SocketAddress>> delegateAddresses) {
        this.clientConnectionExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = Executors.defaultThreadFactory().newThread(r);
                thread.setName("LSP client connection thread");
                return thread;
            }
        });
        CompletableFuture<Void> future = CompletableFuture.runAsync(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (serverSocket.isClosed()) {
                        LanguageServerImpl.this.err.println("[Graal LSP] Server socket is closed.");
                        return;
                    }
                    LanguageServerImpl.this.info.println("[Graal LSP] Starting server and listening on " + serverSocket.getLocalSocketAddress());
                    try (Socket clientSocket = serverSocket.accept();){
                        LanguageServerImpl.this.info.println("[Graal LSP] Client connected on " + clientSocket.getRemoteSocketAddress());
                        ExecutorService lspRequestExecutor = Executors.newCachedThreadPool(new ThreadFactory(){
                            private final ThreadFactory factory = Executors.defaultThreadFactory();

                            @Override
                            public Thread newThread(Runnable r) {
                                Thread thread = this.factory.newThread(r);
                                thread.setName("LSP client request handler " + thread.getName());
                                return thread;
                            }
                        });
                        OutputStream serverOutput = clientSocket.getOutputStream();
                        DelegateServers delegateServers = this.createDelegateServers(serverOutput);
                        Future<?> listenFuture = LanguageServer.Session.connect(LanguageServerImpl.this, clientSocket.getInputStream(), serverOutput, lspRequestExecutor, delegateServers);
                        try {
                            listenFuture.get();
                        }
                        catch (InterruptedException | ExecutionException e) {
                            LanguageServerImpl.this.err.println("[Graal LSP] Error: " + e.getLocalizedMessage());
                        }
                        finally {
                            lspRequestExecutor.shutdown();
                        }
                    }
                }
                catch (IOException e) {
                    LanguageServerImpl.this.err.println("[Graal LSP] Error while connecting to client: " + e.getLocalizedMessage());
                }
            }

            private DelegateServers createDelegateServers(OutputStream serverOutput) {
                List<LanguageServer.DelegateServer> delegateServersList;
                if (delegateAddresses.isEmpty()) {
                    delegateServersList = Collections.emptyList();
                } else {
                    delegateServersList = new ArrayList(delegateAddresses.size());
                    for (Pair langAddress : delegateAddresses) {
                        String languageId = (String)langAddress.getLeft();
                        SocketAddress address = (SocketAddress)langAddress.getRight();
                        try {
                            delegateServersList.add(new LanguageServer.DelegateServer(languageId, address, serverOutput, LanguageServerImpl.this.truffleAdapter, LanguageServerImpl.this.getLogger()));
                        }
                        catch (IOException ex) {
                            LanguageServerImpl.this.err.println("[Graal LSP] Error while connecting to delegate server at " + address + " : " + ex.getLocalizedMessage());
                        }
                    }
                }
                return new DelegateServers(LanguageServerImpl.this.truffleAdapter, delegateServersList, LanguageServerImpl.this.getLogger());
            }
        }, this.clientConnectionExecutor);
        return future;
    }
}

