/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.trufflenode.serialization;

public enum SerializationTag {
    TRUE('T'),
    FALSE('F'),
    UNDEFINED('_'),
    NULL('0'),
    INT32('I'),
    UINT32('U'),
    DOUBLE('N'),
    BIG_INT('Z'),
    UTF8_STRING('S'),
    ONE_BYTE_STRING('\"'),
    TWO_BYTE_STRING('c'),
    PADDING('\u0000'),
    DATE('D'),
    TRUE_OBJECT('y'),
    FALSE_OBJECT('x'),
    NUMBER_OBJECT('n'),
    BIG_INT_OBJECT('z'),
    STRING_OBJECT('s'),
    REGEXP('R'),
    ARRAY_BUFFER('B'),
    SHARED_ARRAY_BUFFER('u'),
    ARRAY_BUFFER_TRANSFER('t'),
    ARRAY_BUFFER_VIEW('V'),
    BEGIN_JS_MAP(';'),
    END_JS_MAP(':'),
    BEGIN_JS_SET('\''),
    END_JS_SET(','),
    BEGIN_JS_OBJECT('o'),
    END_JS_OBJECT('{'),
    BEGIN_SPARSE_JS_ARRAY('a'),
    END_SPARSE_JS_ARRAY('@'),
    BEGIN_DENSE_JS_ARRAY('A'),
    END_DENSE_JS_ARRAY('$'),
    THE_HOLE('-'),
    OBJECT_REFERENCE('^'),
    HOST_OBJECT('\\'),
    ERROR('r'),
    SHARED_JAVA_OBJECT('J');

    private final byte tag;

    private SerializationTag(char tag) {
        this.tag = (byte)tag;
    }

    public byte getTag() {
        return this.tag;
    }

    public static SerializationTag fromTag(byte tag) {
        for (SerializationTag t : SerializationTag.values()) {
            if (t.tag != tag) continue;
            return t;
        }
        return null;
    }
}

