/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.trufflenode;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.js.runtime.interop.InteropArray;

@ExportLibrary(value=InteropLibrary.class)
public final class RunnableInvoker
implements TruffleObject {
    private static final String RUN_METHOD_NAME = "run";
    private final Runnable runnable;

    public RunnableInvoker(Runnable runnable) {
        this.runnable = runnable;
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean isMemberInvocable(String name) {
        return RUN_METHOD_NAME.equals(name);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object invokeMember(String name, Object[] args) throws UnknownIdentifierException {
        if (RUN_METHOD_NAME.equals(name)) {
            this.runnable.run();
            return null;
        }
        throw UnknownIdentifierException.create((String)name);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getMembers(boolean includeInternal) {
        return InteropArray.create((Object[])new Object[]{RUN_METHOD_NAME});
    }
}

