/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.heap;

import java.util.HashMap;
import java.util.Map;
import org.graalvm.visualvm.lib.jfluid.heap.PrimitiveType;
import org.graalvm.visualvm.lib.jfluid.heap.Type;

class HprofPrimitiveType
implements PrimitiveType {
    private static Map primitiveTypeMap = new HashMap(10);
    private String typeName;

    private HprofPrimitiveType(String name) {
        this.typeName = name;
    }

    @Override
    public String getName() {
        return this.typeName;
    }

    static Type getType(byte type) {
        return (Type)primitiveTypeMap.get(type);
    }

    static {
        primitiveTypeMap.put(4, new HprofPrimitiveType("boolean"));
        primitiveTypeMap.put(5, new HprofPrimitiveType("char"));
        primitiveTypeMap.put(6, new HprofPrimitiveType("float"));
        primitiveTypeMap.put(7, new HprofPrimitiveType("double"));
        primitiveTypeMap.put(8, new HprofPrimitiveType("byte"));
        primitiveTypeMap.put(9, new HprofPrimitiveType("short"));
        primitiveTypeMap.put(10, new HprofPrimitiveType("int"));
        primitiveTypeMap.put(11, new HprofPrimitiveType("long"));
    }
}

