/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.coverage.impl;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.graalvm.options.OptionType;

class WildcardHandler {
    static final OptionType<Object[]> WILDCARD_FILTER_TYPE = new OptionType("Expression", (Function)new Function<String, Object[]>(){

        @Override
        public Object[] apply(String filterWildcardExpression) {
            if (filterWildcardExpression == null) {
                return null;
            }
            String[] expressions = filterWildcardExpression.split(",");
            Object[] builtExpressions = new Object[expressions.length];
            for (int i = 0; i < expressions.length; ++i) {
                String expression = expressions[i];
                expression = expression.trim();
                Object result = expression;
                if (expression.contains("?") || expression.contains("*")) {
                    try {
                        result = Pattern.compile(WildcardHandler.wildcardToRegex(expression));
                    }
                    catch (PatternSyntaxException e) {
                        throw new IllegalArgumentException(String.format("Invalid wildcard pattern %s.", expression), e);
                    }
                }
                builtExpressions[i] = result;
            }
            return builtExpressions;
        }
    }, (Consumer)new Consumer<Object[]>(){

        @Override
        public void accept(Object[] objects) {
        }
    });

    WildcardHandler() {
    }

    private static String wildcardToRegex(String wildcard) {
        StringBuilder s = new StringBuilder(wildcard.length());
        s.append('^');
        int is = wildcard.length();
        block5: for (int i = 0; i < is; ++i) {
            char c = wildcard.charAt(i);
            switch (c) {
                case '*': {
                    s.append("\\S*");
                    continue block5;
                }
                case '?': {
                    s.append("\\S");
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    s.append("\\");
                    s.append(c);
                    continue block5;
                }
                default: {
                    s.append(c);
                }
            }
        }
        s.append('$');
        return s.toString();
    }

    static boolean testWildcardExpressions(String value, Object[] fileFilters) {
        if (fileFilters == null || fileFilters.length == 0) {
            return true;
        }
        if (value == null) {
            return false;
        }
        for (Object filter : fileFilters) {
            if (filter instanceof Pattern) {
                if (!((Pattern)filter).matcher(value).matches()) continue;
                return true;
            }
            if (filter instanceof String) {
                if (!filter.equals(value)) continue;
                return true;
            }
            throw new AssertionError();
        }
        return false;
    }
}

