/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.coverage;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.tools.coverage.AbstractCoverageNode;

final class BooleanCoverageNode
extends AbstractCoverageNode {
    private final Assumption noReset;
    @CompilerDirectives.CompilationFinal
    volatile boolean coveredFinal;
    volatile boolean covered;

    BooleanCoverageNode(SourceSection sourceSection, Node instrumentedNode, boolean isRoot, boolean isStatement, Assumption noReset) {
        super(sourceSection, instrumentedNode, isRoot, isStatement);
        this.noReset = noReset;
    }

    @Override
    boolean isCovered() {
        if (this.noReset.isValid()) {
            return this.coveredFinal;
        }
        return this.covered;
    }

    @Override
    void reset() {
        this.covered = false;
    }

    protected void onEnter(VirtualFrame frame) {
        if (this.noReset.isValid()) {
            if (!this.coveredFinal) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.coveredFinal = true;
                this.covered = true;
            }
        } else {
            this.covered = true;
        }
    }
}

