/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.helper;

import com.ibm.j9ddr.AddressedCorruptDataException;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.InvalidDataTypeException;
import com.ibm.j9ddr.vm29.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffsetIterator;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ArrayClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ITablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VTableHeaderPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9MethodHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMMethodHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.structure.J9Class;
import com.ibm.j9ddr.vm29.structure.J9Consts;
import com.ibm.j9ddr.vm29.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm29.structure.J9Method;
import com.ibm.j9ddr.vm29.structure.J9ROMFieldOffsetWalkState;
import com.ibm.j9ddr.vm29.structure.J9VTableHeader;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.UDATA;
import com.ibm.j9ddr.vm29.types.UScalar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class J9ClassHelper {
    private static HashMap<Long, HashMap<String, J9ObjectFieldOffset>> classToFieldOffsetCacheMap = new HashMap();
    private static final Map<String, Character> TYPE_MAP = new HashMap<String, Character>();
    private static final int MAXIMUM_ARRAY_ARITY = 100;
    private static final int SYNTHETIC = 4096;
    private static final int ANNOTATION = 8192;
    private static final int ENUM = 16384;

    public static boolean isArrayClass(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        return J9ClassHelper.classDepthAndFlags(j9ClassPointer).anyBitsIn(J9JavaAccessFlags.J9AccClassRAMArray);
    }

    public static String getName(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        return J9UTF8Helper.stringValue(j9ClassPointer.romClass().className());
    }

    public static String getSignature(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        String string;
        Character c;
        String string2 = J9ClassHelper.isArrayClass(j9ClassPointer) ? J9ClassHelper.getArrayName(j9ClassPointer) : ((c = TYPE_MAP.get(string = J9ClassHelper.getName(j9ClassPointer))) != null ? c.toString() : 'L' + string + ';');
        return string2;
    }

    public static String getArrayName(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        J9ArrayClassPointer j9ArrayClassPointer = J9ArrayClassPointer.cast(j9ClassPointer);
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        try {
            n = j9ArrayClassPointer.arity().intValue();
        }
        catch (InvalidDataTypeException invalidDataTypeException) {
            throw new AddressedCorruptDataException(j9ArrayClassPointer.getAddress(), "Array arity larger than MAXINT");
        }
        if (n > 100) {
            throw new AddressedCorruptDataException(j9ArrayClassPointer.getAddress(), "Very high arity " + n + " from array class 0x" + Long.toHexString(j9ArrayClassPointer.getAddress()));
        }
        for (int i = 0; i < n; ++i) {
            stringBuilder.append('[');
        }
        String string = J9ClassHelper.getName(j9ArrayClassPointer.leafComponentType());
        Character c = TYPE_MAP.get(string);
        if (c != null) {
            stringBuilder.append(c);
        } else {
            stringBuilder.append('L');
            stringBuilder.append(string);
            stringBuilder.append(";");
        }
        return stringBuilder.toString();
    }

    public static String getJavaName(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        String string = J9ClassHelper.getName(j9ClassPointer);
        char c = string.charAt(0);
        if (c != '[') {
            return string;
        }
        J9ArrayClassPointer j9ArrayClassPointer = J9ArrayClassPointer.cast(j9ClassPointer);
        int n = j9ArrayClassPointer.arity().intValue();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("[]");
        }
        String string2 = stringBuilder.toString();
        c = string.charAt(1);
        switch (c) {
            case 'B': {
                return "byte" + string2;
            }
            case 'C': {
                return "char" + string2;
            }
            case 'D': {
                return "double" + string2;
            }
            case 'F': {
                return "float" + string2;
            }
            case 'I': {
                return "int" + string2;
            }
            case 'J': {
                return "long" + string2;
            }
            case 'S': {
                return "void" + string2;
            }
            case 'V': {
                return "void" + string2;
            }
            case 'Z': {
                return "boolean" + string2;
            }
            case 'L': {
                return J9ClassHelper.getName(j9ArrayClassPointer.leafComponentType()) + string2;
            }
        }
        return string;
    }

    public static String formatFullInteractive(J9ClassPointer j9ClassPointer) {
        String string;
        String string2 = j9ClassPointer.formatFullInteractive();
        try {
            string = String.format("\nClass name: %s\nTo view instance shape, use !j9classshape %s", J9ClassHelper.getName(j9ClassPointer), j9ClassPointer.getHexAddress());
        }
        catch (CorruptDataException corruptDataException) {
            string = String.format("\nClass name: <ERROR>\n To view instance shape, use !j9classshape %s", j9ClassPointer.getHexAddress());
        }
        return string2 + string;
    }

    public static Iterator<J9ObjectFieldOffset> getFieldOffsets(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        U32 u32 = new U32(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_STATIC | J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_INSTANCE);
        return J9ObjectFieldOffsetIterator.J9ObjectFieldOffsetIteratorFor(j9ClassPointer, J9ClassHelper.superclass(j9ClassPointer), u32);
    }

    public static J9ClassPointer superclass(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        long l = J9ClassHelper.classDepth(j9ClassPointer).longValue() - 1L;
        if (l < 0L) {
            return J9ClassPointer.NULL;
        }
        VoidPointer voidPointer = j9ClassPointer.superclasses().at(l);
        return J9ClassPointer.cast(voidPointer);
    }

    private static HashMap<String, J9ObjectFieldOffset> getFieldOffsetCache(J9ClassPointer j9ClassPointer) {
        Long l = j9ClassPointer.getAddress();
        HashMap<String, J9ObjectFieldOffset> hashMap = classToFieldOffsetCacheMap.get(l);
        if (null != hashMap) {
            return hashMap;
        }
        hashMap = new HashMap();
        classToFieldOffsetCacheMap.put(l, hashMap);
        return hashMap;
    }

    public static J9ObjectFieldOffset checkFieldOffsetCache(J9ClassPointer j9ClassPointer, String string, String string2) {
        HashMap<String, J9ObjectFieldOffset> hashMap = J9ClassHelper.getFieldOffsetCache(j9ClassPointer);
        return hashMap.get(string + "." + string2);
    }

    public static void setFieldOffsetCache(J9ClassPointer j9ClassPointer, J9ObjectFieldOffset j9ObjectFieldOffset, String string, String string2) {
        HashMap<String, J9ObjectFieldOffset> hashMap = J9ClassHelper.getFieldOffsetCache(j9ClassPointer);
        hashMap.put(string + "." + string2, j9ObjectFieldOffset);
    }

    public static boolean isSameOrSuperClassOf(J9ClassPointer j9ClassPointer, J9ClassPointer j9ClassPointer2) throws CorruptDataException {
        long l = J9ClassHelper.classDepth(j9ClassPointer).longValue();
        if (j9ClassPointer.eq(j9ClassPointer2)) {
            return true;
        }
        if (J9ClassHelper.classDepth(j9ClassPointer2).longValue() > l) {
            return j9ClassPointer.eq(j9ClassPointer2.superclasses().at(l));
        }
        return false;
    }

    public static J9VTableHeaderPointer vTableHeader(J9ClassPointer j9ClassPointer) {
        J9VTableHeaderPointer j9VTableHeaderPointer = J9VTableHeaderPointer.cast(j9ClassPointer.add(1L));
        return j9VTableHeaderPointer;
    }

    public static UDATAPointer vTable(J9VTableHeaderPointer j9VTableHeaderPointer) {
        UDATAPointer uDATAPointer = UDATAPointer.cast(j9VTableHeaderPointer.add(1L));
        return uDATAPointer;
    }

    public static UDATAPointer oldVTable(J9ClassPointer j9ClassPointer) {
        UDATAPointer uDATAPointer = UDATAPointer.cast(j9ClassPointer.add(1L));
        return uDATAPointer;
    }

    public static UDATA size(J9ClassPointer j9ClassPointer, J9JavaVMPointer j9JavaVMPointer) throws CorruptDataException {
        DataType dataType;
        DataType dataType2;
        UDATA uDATA;
        UDATA uDATA2 = new UDATA(J9Class.SIZEOF);
        UDATA uDATA3 = AlgorithmVersion.getVersionOf("ALG_VM_VTABLE_VERSION").getAlgorithmVersion() >= 1 ? J9ClassHelper.vTableHeader(j9ClassPointer).size().add(J9VTableHeader.SIZEOF / (long)UDATA.SIZEOF) : J9ClassHelper.oldVTable(j9ClassPointer).at(0L);
        uDATA2 = uDATA2.add(Scalar.convertSlotsToBytes(uDATA3));
        if (j9JavaVMPointer.jitConfig().notNull()) {
            uDATA = uDATA3.sub(1L);
            uDATA2 = uDATA2.add(Scalar.convertSlotsToBytes(uDATA));
        }
        if (!J9ROMClassHelper.isArray(j9ClassPointer.romClass())) {
            uDATA = j9ClassPointer.romClass().romMethodCount().mult((int)J9Method.SIZEOF);
            uDATA2 = uDATA2.add(uDATA);
            if (j9JavaVMPointer.runtimeFlags().allBitsIn(J9Consts.J9_RUNTIME_EXTENDED_METHOD_BLOCK)) {
                dataType2 = Scalar.roundToSizeofUDATA(new UDATA(j9ClassPointer.romClass().romMethodCount()));
                uDATA2 = uDATA2.add((UScalar)dataType2);
            }
            if (!j9ClassPointer.instanceDescription().anyBitsIn(1L)) {
                dataType2 = new UDATA(UDATA.SIZEOF * 8 - 1);
                dataType = j9ClassPointer.totalInstanceSize().rightShift((int)(ObjectReferencePointer.SIZEOF >> 2) + 1);
                dataType = ((UDATA)dataType).add((UScalar)dataType2).bitAnd(((UDATA)dataType2).bitNot());
                if (J9BuildFlags.gc_leafBits) {
                    dataType = ((UDATA)dataType).mult(2);
                }
                uDATA2 = uDATA2.add((UScalar)dataType);
            }
            dataType2 = j9ClassPointer.romClass().objectStaticCount().add(j9ClassPointer.romClass().singleScalarStaticCount());
            dataType2 = J9BuildFlags.env_data64 ? ((UDATA)dataType2).add(j9ClassPointer.romClass().doubleScalarStaticCount()) : ((UDATA)dataType2).add(1L).bitAnd(-2L).add(j9ClassPointer.romClass().doubleScalarStaticCount().mult(2));
            uDATA2 = uDATA2.add(Scalar.convertSlotsToBytes(new UDATA((Scalar)dataType2)));
            dataType = j9ClassPointer.romClass().ramConstantPoolCount().mult(2);
            uDATA2 = uDATA2.add(Scalar.convertSlotsToBytes(new UDATA((Scalar)dataType)));
        }
        uDATA2 = (uDATA = J9ClassHelper.classDepthAndFlags(j9ClassPointer).bitAnd(J9JavaAccessFlags.J9AccClassDepthMask)).eq(0L) ? uDATA2.add(UDATA.SIZEOF) : uDATA2.add(Scalar.convertSlotsToBytes(uDATA));
        if (j9ClassPointer.iTable().notNull() && (((AbstractPointer)(dataType2 = J9ClassPointer.cast(j9ClassPointer.superclasses().at(uDATA.sub(1L))))).isNull() || !((J9ClassPointer)dataType2).iTable().eq(j9ClassPointer.iTable()))) {
            dataType = J9ITablePointer.cast(j9ClassPointer.iTable());
            if (((AbstractPointer)dataType2).isNull()) {
                while (((J9ITablePointer)dataType).next().notNull()) {
                    dataType = ((J9ITablePointer)dataType).next();
                }
            } else {
                while (((J9ITablePointer)dataType).next().notNull() && !((J9ITablePointer)dataType).next().eq(((J9ClassPointer)dataType2).iTable())) {
                    dataType = ((J9ITablePointer)dataType).next();
                }
            }
            dataType = j9ClassPointer.romClass().modifiers().allBitsIn(J9JavaAccessFlags.J9AccInterface) ? ((J9ITablePointer)dataType).add(1L) : ((J9ITablePointer)dataType).add(1L).addOffset(((J9ITablePointer)dataType).interfaceClass().romClass().romMethodCount().mult(UDATA.SIZEOF));
            uDATA2 = uDATA2.add(((AbstractPointer)dataType).getAddress() - j9ClassPointer.iTable().getAddress());
        }
        return uDATA2;
    }

    public static int getJavaLangClassModifiers(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        int n = J9ClassHelper.getRawModifiers(j9ClassPointer);
        n = J9ClassHelper.isArrayClass(j9ClassPointer) ? (n &= 0x417) : (n &= 0x761F);
        return n;
    }

    public static int getRawModifiers(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        if (J9ClassHelper.isArrayClass(j9ClassPointer)) {
            J9ArrayClassPointer j9ArrayClassPointer = J9ArrayClassPointer.cast(j9ClassPointer);
            UDATA uDATA = j9ArrayClassPointer.leafComponentType().romClass().modifiers();
            uDATA = uDATA.bitOr(J9JavaAccessFlags.J9AccAbstract);
            uDATA = uDATA.bitOr(J9JavaAccessFlags.J9AccFinal);
            return uDATA.intValue();
        }
        UDATA uDATA = j9ClassPointer.romClass().modifiers();
        if (j9ClassPointer.romClass().outerClassName().notNull()) {
            uDATA = j9ClassPointer.romClass().memberAccessFlags();
        }
        return uDATA.intValue();
    }

    public static UDATA classDepthAndFlags(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        return j9ClassPointer.classDepthAndFlags();
    }

    public static UDATA classDepth(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        return J9ClassHelper.classDepthAndFlags(j9ClassPointer).bitAnd(J9JavaAccessFlags.J9AccClassDepthMask);
    }

    public static U32 extendedClassFlags(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        return new U32(j9ClassPointer.classFlags());
    }

    public static UDATA classFlags(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        return J9ClassHelper.classDepthAndFlags(j9ClassPointer);
    }

    public static boolean isObsolete(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        return J9ClassHelper.classDepthAndFlags(j9ClassPointer).allBitsIn(J9JavaAccessFlags.J9AccClassHotSwappedOut);
    }

    public static J9ClassPointer currentClass(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        return J9ClassHelper.isObsolete(j9ClassPointer) ? j9ClassPointer.arrayClass() : j9ClassPointer;
    }

    public static J9MethodPointer getMethodFromPCAndClass(J9ClassPointer j9ClassPointer, U8Pointer u8Pointer) throws CorruptDataException {
        J9ROMClassPointer j9ROMClassPointer = j9ClassPointer.romClass();
        int n = 0;
        while ((long)n < j9ROMClassPointer.romMethodCount().longValue()) {
            J9MethodPointer j9MethodPointer = j9ClassPointer.ramMethods().add(n);
            J9ROMMethodPointer j9ROMMethodPointer = J9MethodHelper.romMethod(j9MethodPointer);
            boolean bl = u8Pointer.gte(U8Pointer.cast(j9ROMMethodPointer));
            boolean bl2 = u8Pointer.lte(J9ROMMethodHelper.bytecodeEnd(j9ROMMethodPointer).subOffset(1L));
            if (bl && bl2) {
                return j9MethodPointer;
            }
            ++n;
        }
        return J9MethodPointer.NULL;
    }

    public static boolean isSwappedOut(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        return J9ClassHelper.classDepthAndFlags(j9ClassPointer).allBitsIn(J9JavaAccessFlags.J9AccClassHotSwappedOut);
    }

    public static boolean hasValidEyeCatcher(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        return j9ClassPointer.eyecatcher().eq(0x99669966L);
    }

    public static boolean areExtensionsEnabled() throws CorruptDataException {
        J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
        if (j9JavaVMPointer.runtimeFlags().allBitsIn(J9Consts.J9_RUNTIME_XFUTURE)) {
            return false;
        }
        if (J9BuildFlags.interp_nativeSupport) {
            if (J9BuildFlags.jit_fullSpeedDebug) {
                if (j9JavaVMPointer.jitConfig().notNull()) {
                    return !j9JavaVMPointer.jitConfig().fsdEnabled().eq(0L);
                }
                return true;
            }
            if (j9JavaVMPointer.jitConfig().notNull()) {
                return false;
            }
        }
        return true;
    }

    public static boolean isAnonymousClass(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        return J9ROMClassHelper.isAnonymousClass(j9ClassPointer.romClass());
    }

    static {
        TYPE_MAP.put("void", Character.valueOf('V'));
        TYPE_MAP.put("boolean", Character.valueOf('Z'));
        TYPE_MAP.put("byte", Character.valueOf('B'));
        TYPE_MAP.put("char", Character.valueOf('C'));
        TYPE_MAP.put("short", Character.valueOf('S'));
        TYPE_MAP.put("int", Character.valueOf('I'));
        TYPE_MAP.put("long", Character.valueOf('J'));
        TYPE_MAP.put("float", Character.valueOf('F'));
        TYPE_MAP.put("double", Character.valueOf('D'));
    }
}

