/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands;

import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import java.io.File;
import java.io.PrintStream;

@DTFJPlugin(version=".*", runtime=false)
public class PwdCommand
extends BaseJdmpviewCommand {
    public PwdCommand() {
        this.addCommand("pwd", "", "displays the current working directory");
    }

    public void run(String string, String[] stringArray, IContext iContext, PrintStream printStream) throws CommandException {
        if (this.initCommand(string, stringArray, iContext, printStream)) {
            return;
        }
        if (stringArray.length != 0) {
            printStream.println("\"pwd\" does not take any parameters");
            return;
        }
        File file = (File)this.ctx.getProperties().get("pwd");
        printStream.print("\n");
        printStream.print("\t" + file.getPath());
        printStream.print("\n\n");
    }

    @Override
    public void printDetailedHelp(PrintStream printStream) {
        printStream.println("displays the current working directory\n\nparameters: none\n\ndisplays the current working directory, which is the directory where log files are stored; see the help for \"cd\" for more information\n");
    }
}

