/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.view.dtfj.java;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.java.JavaHeap;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.events.IEventListener;
import com.ibm.j9ddr.util.IteratorHelpers;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageSection;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.gc.GCExtensions;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionIterator;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_HeapRegionDescriptorPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_HeapRegionManagerPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_MemorySpacePointer;
import com.ibm.j9ddr.vm29.view.dtfj.DTFJContext;
import com.ibm.j9ddr.vm29.view.dtfj.java.j9.HeapObjectIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class DTFJJavaHeap
implements JavaHeap {
    private final MM_MemorySpacePointer space;
    private String name;
    private String description;
    private ImagePointer id;
    List<GCHeapRegionDescriptor> regions;
    List<Object> objects = null;
    List<ImageSection> sections = null;

    public DTFJJavaHeap(MM_MemorySpacePointer mM_MemorySpacePointer, String string, ImagePointer imagePointer) throws CorruptDataException {
        this.space = mM_MemorySpacePointer;
        this.name = string;
        this.id = imagePointer;
        this.initRegions();
    }

    private void initRegions() throws CorruptDataException {
        MM_GCExtensionsPointer mM_GCExtensionsPointer = GCExtensions.getGCExtensionsPointer();
        MM_HeapRegionManagerPointer mM_HeapRegionManagerPointer = mM_GCExtensionsPointer.heapRegionManager();
        this.regions = IteratorHelpers.toList(GCHeapRegionIterator.fromMMHeapRegionManager(mM_HeapRegionManagerPointer, this.space, true, true));
    }

    public String getName() {
        return this.name + "@" + this.id;
    }

    public Iterator getObjects() {
        return new Iterator(){
            Iterator currentRegionIterator = null;
            Iterator<GCHeapRegionDescriptor> regionsIterator;
            {
                this.regionsIterator = DTFJJavaHeap.this.regions.iterator();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                CurrentRegionListener currentRegionListener = new CurrentRegionListener();
                try {
                    EventManager.register(currentRegionListener);
                    if (null == this.currentRegionIterator || !this.currentRegionIterator.hasNext()) {
                        while (this.regionsIterator.hasNext()) {
                            try {
                                this.currentRegionIterator = new HeapObjectIterator(DTFJJavaHeap.this, this.regionsIterator.next());
                            }
                            catch (Throwable throwable) {
                                CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
                                this.currentRegionIterator = J9DDRDTFJUtils.corruptIterator(corruptData);
                            }
                            if (!this.currentRegionIterator.hasNext()) continue;
                            boolean bl = true;
                            return bl;
                        }
                    }
                    if (null != this.currentRegionIterator) {
                        boolean bl = this.currentRegionIterator.hasNext();
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    EventManager.unregister(currentRegionListener);
                }
            }

            public Object next() {
                if (this.hasNext()) {
                    return this.currentRegionIterator.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove not supported");
            }

            class CurrentRegionListener
            implements IEventListener {
                CurrentRegionListener() {
                }

                @Override
                public void corruptData(String string, CorruptDataException corruptDataException, boolean bl) {
                    if (bl) {
                        currentRegionIterator = J9DDRDTFJUtils.corruptIterator(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), corruptDataException));
                    }
                }
            }
        };
    }

    public Iterator getSections() {
        try {
            if (null == this.sections) {
                ArrayList<ImageSection> arrayList = new ArrayList<ImageSection>();
                Iterator<GCHeapRegionDescriptor> iterator = this.regions.iterator();
                while (iterator.hasNext()) {
                    try {
                        GCHeapRegionDescriptor gCHeapRegionDescriptor = iterator.next();
                        long l = gCHeapRegionDescriptor.getLowAddress().getAddress();
                        long l2 = gCHeapRegionDescriptor.getHighAddress().getAddress() - l;
                        String string = String.format("Heap extent at 0x%x (0x%x bytes)", l, l2);
                        arrayList.add(new J9DDRImageSection(MM_HeapRegionDescriptorPointer.getProcess(), l, l2, string));
                    }
                    catch (Throwable throwable) {
                        CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
                        arrayList.add((ImageSection)corruptData);
                    }
                }
                this.sections = arrayList;
            }
            return this.sections.iterator();
        }
        catch (Throwable throwable) {
            CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
            return J9DDRDTFJUtils.corruptIterator(corruptData);
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DTFJJavaHeap)) {
            return false;
        }
        DTFJJavaHeap dTFJJavaHeap = (DTFJJavaHeap)object;
        return this.space.eq(dTFJJavaHeap.space);
    }

    public int hashCode() {
        return this.space.hashCode();
    }

    public String toString() {
        if (this.description == null) {
            try {
                U8Pointer u8Pointer = U8Pointer.cast(-1L);
                U8Pointer u8Pointer2 = U8Pointer.cast(0L);
                String string = this.space._name().getCStringAtOffset(0L);
                for (GCHeapRegionDescriptor gCHeapRegionDescriptor : this.regions) {
                    U8Pointer u8Pointer3 = U8Pointer.cast(gCHeapRegionDescriptor.getLowAddress());
                    U8Pointer u8Pointer4 = U8Pointer.cast(gCHeapRegionDescriptor.getHighAddress());
                    if (u8Pointer3.lt(u8Pointer)) {
                        u8Pointer = u8Pointer3;
                    }
                    if (!u8Pointer4.gt(u8Pointer2)) continue;
                    u8Pointer2 = u8Pointer4;
                }
                this.description = String.format("%s [%s, Span: 0x%08x->0x%08x, Regions: %d]", this.getName(), string, u8Pointer.getAddress(), u8Pointer2.getAddress(), this.regions.size());
            }
            catch (Throwable throwable) {
                J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
                this.description = super.toString();
            }
        }
        return this.description;
    }
}

