/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.ObjectAccessBarrier;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9IndexableObjectContiguousPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9IndexableObjectDiscontiguousPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectMonitorPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMFieldShapePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMFieldShapeHelper;
import com.ibm.j9ddr.vm29.types.IDATA;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.U64;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

public abstract class AbstractPointer
extends DataType {
    private static int cacheSize = 32;
    private static long[] keys;
    private static J9ClassPointer[] values;
    private static int[] counts;
    private static long probes;
    private static long hits;
    protected long address;

    protected AbstractPointer(long l) {
        this.address = l;
        if (4 == DataType.getProcess().bytesPerPointer()) {
            this.address = 0xFFFFFFFFL & l;
        }
    }

    public abstract AbstractPointer add(long var1);

    public abstract AbstractPointer add(Scalar var1);

    public abstract AbstractPointer addOffset(long var1);

    public abstract AbstractPointer addOffset(Scalar var1);

    public abstract AbstractPointer sub(long var1);

    public abstract AbstractPointer sub(Scalar var1);

    public abstract AbstractPointer subOffset(long var1);

    public abstract AbstractPointer subOffset(Scalar var1);

    public abstract AbstractPointer untag(long var1);

    public abstract AbstractPointer untag();

    @Deprecated
    public boolean isTagged(long l) {
        return 0L != (this.address & l);
    }

    public boolean allBitsIn(long l) {
        return l == (this.address & l);
    }

    public boolean anyBitsIn(long l) {
        return 0L != (this.address & l);
    }

    @Override
    public long longValue() throws CorruptDataException {
        return this.address;
    }

    public abstract DataType at(long var1) throws CorruptDataException;

    public abstract DataType at(Scalar var1) throws CorruptDataException;

    @Deprecated
    public long longAt(long l) throws CorruptDataException {
        return this.at(l).longValue();
    }

    @Deprecated
    public long longAt(Scalar scalar) throws CorruptDataException {
        return this.longAt(scalar.longValue());
    }

    @Deprecated
    public float floatAt(long l) throws CorruptDataException {
        return this.longAt(l);
    }

    @Deprecated
    public float floatAt(Scalar scalar) throws CorruptDataException {
        return this.floatAt(scalar.longValue());
    }

    @Deprecated
    public double doubleAt(long l) throws CorruptDataException {
        return this.longAt(l);
    }

    @Deprecated
    public double doubleAt(Scalar scalar) throws CorruptDataException {
        return this.doubleAt(scalar.longValue());
    }

    @Deprecated
    public boolean boolAt(long l) throws CorruptDataException {
        return this.longAt(l) != 0L;
    }

    @Deprecated
    public boolean boolAt(Scalar scalar) throws CorruptDataException {
        return this.boolAt(scalar.longValue());
    }

    public boolean isNull() {
        return this.address == 0L;
    }

    public boolean notNull() {
        return this.address != 0L;
    }

    public boolean eq(Object object) {
        return this.equals(object);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof AbstractPointer)) {
            return false;
        }
        return this.address == ((AbstractPointer)object).address;
    }

    public int hashCode() {
        return (int)(0xFFFFFFFFL & this.address ^ (0xFFFFFFFF00000000L & this.address) >> 32);
    }

    public long getAddress() {
        return this.address;
    }

    public final long nonNullAddress() throws NullPointerDereference {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return this.address;
    }

    public String getHexAddress() {
        return String.format("0x%0" + UDATA.SIZEOF * 2 + "X", this.address);
    }

    public String hexAt(long l) throws CorruptDataException {
        String string = "0x";
        int n = this instanceof StructurePointer ? UDATA.SIZEOF : (int)this.sizeOfBaseType();
        byte[] byArray = new byte[n];
        this.getBytesAtOffset(l, byArray);
        for (int i = 0; i < byArray.length; ++i) {
            string = string + String.format("%02X", byArray[i]);
        }
        return string;
    }

    public String hexAt(Scalar scalar) throws CorruptDataException {
        return this.hexAt(scalar.longValue());
    }

    public String getHexValue() throws CorruptDataException {
        String string = "0x";
        int n = this instanceof StructurePointer ? UDATA.SIZEOF : (int)this.sizeOfBaseType();
        byte[] byArray = new byte[n];
        this.getBytesAtOffset(0L, byArray);
        if (J9BuildFlags.env_littleEndian) {
            for (int i = byArray.length - 1; i >= 0; --i) {
                string = string + String.format("%02X", byArray[i]);
            }
        } else {
            for (int i = 0; i < byArray.length; ++i) {
                string = string + String.format("%02X", byArray[i]);
            }
        }
        return string;
    }

    protected static IProcess getAddressSpace() {
        return process;
    }

    public boolean lt(AbstractPointer abstractPointer) {
        if (J9BuildFlags.env_data64) {
            return new U64(this.address).lt(new U64(abstractPointer.address));
        }
        return this.address < abstractPointer.address;
    }

    public boolean lte(AbstractPointer abstractPointer) {
        if (J9BuildFlags.env_data64) {
            return new U64(this.address).lte(new U64(abstractPointer.address));
        }
        return this.address <= abstractPointer.address;
    }

    public boolean gt(AbstractPointer abstractPointer) {
        if (J9BuildFlags.env_data64) {
            return new U64(this.address).gt(new U64(abstractPointer.address));
        }
        return this.address > abstractPointer.address;
    }

    public boolean gte(AbstractPointer abstractPointer) {
        if (J9BuildFlags.env_data64) {
            return new U64(this.address).gte(new U64(abstractPointer.address));
        }
        return this.address >= abstractPointer.address;
    }

    public IDATA sub(AbstractPointer abstractPointer) {
        if (this.getClass() != abstractPointer.getClass()) {
            throw new UnsupportedOperationException("Cannot subtract different pointer types. This type = " + this.getClass() + ", parameter type = " + abstractPointer.getClass());
        }
        IDATA iDATA = new IDATA(this.address).sub(new IDATA(abstractPointer.address));
        return new IDATA(iDATA.longValue() / this.sizeOfBaseType());
    }

    protected abstract long sizeOfBaseType();

    public int compare(AbstractPointer abstractPointer) {
        return this.address == abstractPointer.address ? 0 : (this.lt(abstractPointer) ? -1 : 1);
    }

    public String toString() {
        String string = this.getClass().getName();
        try {
            if (this instanceof J9ObjectPointer || this instanceof J9IndexableObjectPointer || this instanceof J9IndexableObjectContiguousPointer || this instanceof J9IndexableObjectDiscontiguousPointer) {
                string = J9ObjectHelper.getClassName(J9ObjectPointer.cast(this));
            }
            if (this instanceof J9ROMFieldShapePointer) {
                return J9ROMFieldShapeHelper.toString(J9ROMFieldShapePointer.cast(this));
            }
            if (this.address == 0L) {
                return String.format("%s @ 00000", string);
            }
            return String.format("%s @ 0x%08X %n%s", string, this.address, this.getMemString(16));
        }
        catch (CorruptDataException corruptDataException) {
            return super.toString();
        }
    }

    private String getMemString(int n) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        this.dumpHex(n, printStream);
        return byteArrayOutputStream.toString();
    }

    private void dumpHex(int n, PrintStream printStream) {
        if (this.isNull()) {
            return;
        }
        printStream.println();
        for (int i = 0; i < n; ++i) {
            try {
                int n2 = AbstractPointer.getAddressSpace().getIntAt(this.address + (long)(i * 4));
                if (i % 4 == 0) {
                    printStream.print(String.format("%08X : ", this.getAddress() + (long)(i * 4)));
                }
                printStream.print(String.format("%08X ", n2));
                if (i % 4 != 3) continue;
                printStream.println();
                continue;
            }
            catch (CorruptDataException corruptDataException) {
                printStream.print(" FAULT ");
            }
        }
        printStream.println();
    }

    protected long getPointerAtOffset(long l) throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return AbstractPointer.getAddressSpace().getPointerAt(this.address + l);
    }

    protected int getIntAtOffset(long l) throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return AbstractPointer.getAddressSpace().getIntAt(this.address + l);
    }

    protected double getDoubleAtOffset(long l) throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        long l2 = AbstractPointer.getAddressSpace().getLongAt(this.address + l);
        return Double.longBitsToDouble(l2);
    }

    protected float getFloatAtOffset(long l) throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        int n = AbstractPointer.getAddressSpace().getIntAt(this.address + l);
        return Float.intBitsToFloat(n);
    }

    protected boolean getBoolAtOffset(long l) throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        switch (SIZEOF_BOOL) {
            case 1: {
                return 0 != AbstractPointer.getAddressSpace().getByteAt(this.address + l);
            }
            case 2: {
                return 0 != AbstractPointer.getAddressSpace().getShortAt(this.address + l);
            }
            case 4: {
                return 0 != AbstractPointer.getAddressSpace().getIntAt(this.address + l);
            }
            case 8: {
                return 0L != AbstractPointer.getAddressSpace().getLongAt(this.address + l);
            }
        }
        byte[] byArray = new byte[SIZEOF_BOOL];
        AbstractPointer.getAddressSpace().getBytesAt(this.address + l, byArray);
        for (int i = 0; i < SIZEOF_BOOL; ++i) {
            if (0 == byArray[i]) continue;
            return true;
        }
        return false;
    }

    protected UDATA getUDATAAtOffset(long l) throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        if (J9BuildFlags.env_data64) {
            return new UDATA(AbstractPointer.getAddressSpace().getLongAt(this.address + l));
        }
        return new UDATA(AbstractPointer.getAddressSpace().getIntAt(this.address + l));
    }

    protected IDATA getIDATAAtOffset(long l) throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        if (J9BuildFlags.env_data64) {
            return new IDATA(AbstractPointer.getAddressSpace().getLongAt(this.address + l));
        }
        return new IDATA(AbstractPointer.getAddressSpace().getIntAt(this.address + l));
    }

    protected short getShortAtOffset(long l) throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return AbstractPointer.getAddressSpace().getShortAt(this.address + l);
    }

    protected byte getByteAtOffset(long l) throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return AbstractPointer.getAddressSpace().getByteAt(this.address + l);
    }

    public int getBytesAtOffset(long l, byte[] byArray) throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return AbstractPointer.getAddressSpace().getBytesAt(this.address + l, byArray);
    }

    protected char getBaseCharAtOffset(long l) throws CorruptDataException {
        return (char)(this.getShortAtOffset(l) & 0xFFFF);
    }

    protected long getLongAtOffset(long l) throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return AbstractPointer.getAddressSpace().getLongAt(this.address + l);
    }

    protected J9ObjectPointer getObjectReferenceAtOffset(long l) throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        if (J9ObjectHelper.compressObjectReferences) {
            return ObjectAccessBarrier.convertPointerFromToken(AbstractPointer.getAddressSpace().getIntAt(this.address + l));
        }
        return J9ObjectPointer.cast(AbstractPointer.getAddressSpace().getPointerAt(this.address + l));
    }

    protected J9ClassPointer getObjectClassAtOffset(long l) throws CorruptDataException {
        long l2 = this.address + l;
        long l3 = J9ObjectHelper.compressObjectReferences ? (long)AbstractPointer.getAddressSpace().getIntAt(l2) & 0xFFFFFFFFL : AbstractPointer.getAddressSpace().getPointerAt(l2);
        if (l3 == 0L) {
            throw new MemoryFault(l2, "Invalid class address found in object");
        }
        J9ClassPointer j9ClassPointer = AbstractPointer.checkClassCache(l3);
        if (j9ClassPointer == null) {
            j9ClassPointer = J9ClassPointer.cast(l3);
            AbstractPointer.setClassCache(l3, j9ClassPointer);
        }
        return j9ClassPointer;
    }

    private static J9ClassPointer checkClassCache(long l) {
        ++probes;
        for (int i = 0; i < cacheSize; ++i) {
            if (keys[i] != l) continue;
            ++hits;
            int n = i;
            counts[n] = counts[n] + 1;
            return values[i];
        }
        return null;
    }

    private static void setClassCache(long l, J9ClassPointer j9ClassPointer) {
        int n = counts[0];
        int n2 = 0;
        for (int i = 1; i < cacheSize; ++i) {
            if (counts[i] >= n) continue;
            n = counts[i];
            n2 = i;
        }
        AbstractPointer.keys[n2] = l;
        AbstractPointer.values[n2] = j9ClassPointer;
        AbstractPointer.counts[n2] = 1;
    }

    protected J9ObjectMonitorPointer getObjectMonitorAtOffset(long l) throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        if (J9ObjectHelper.compressObjectReferences) {
            return J9ObjectMonitorPointer.cast(0xFFFFFFFFL & (long)AbstractPointer.getAddressSpace().getIntAt(this.address + l));
        }
        return J9ObjectMonitorPointer.cast(AbstractPointer.getAddressSpace().getPointerAt(this.address + l));
    }

    public String formatFullInteractive() {
        return this.toString();
    }

    public String getTargetName() {
        String string = this.getClass().getSimpleName();
        if (string.endsWith("Pointer")) {
            string = string.substring(0, string.length() - "Pointer".length());
        }
        return string;
    }

    @Override
    public String formatShortInteractive() {
        String string = this.getTargetName();
        string = string.toLowerCase();
        return "!" + string + " 0x" + Long.toHexString(this.getAddress());
    }

    private static void initializeCache() {
        keys = new long[cacheSize];
        values = new J9ClassPointer[cacheSize];
        counts = new int[cacheSize];
        probes = 0L;
        hits = 0L;
    }

    public static void reportClassCacheStats() {
        double d = (double)hits / (double)probes * 100.0;
        System.out.println("AbstractPointer probes: " + probes + " hit rate: " + d + "%");
        AbstractPointer.initializeCache();
    }

    static {
        AbstractPointer.initializeCache();
    }
}

