/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive.commands;

import com.ibm.dtfj.image.ImageModule;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.corereaders.ILibraryDependentCore;
import com.ibm.j9ddr.corereaders.memory.IModule;
import com.ibm.j9ddr.libraries.CoreFileResolver;
import com.ibm.j9ddr.libraries.FooterLibraryEntry;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractive;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.tools.ddrinteractive.annotations.DebugExtension;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageProcess;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;

@DebugExtension(VMVersion="*", contentAssist="dclibs")
public class NativeLibrariesCommand
extends Command {
    protected String hexformat = null;

    public NativeLibrariesCommand() {
        this.addCommand("dclibs", "", "List the native libraries collected by DC");
        this.addCommand("dclibs", "extract", "Extract collected libraries into the same directory as the core file");
        this.addCommand("dclibs", "extract overwrite", "as !libs extract, but overwrite any existing files");
        this.addCommand("dclibs", "extract <full path to dir>", "Extract the collected libraries into the specified directory");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        this.hexformat = "0x%0" + context.process.bytesPerPointer() * 2 + "x";
        if (DDRInteractive.getPath() == null || DDRInteractive.getPath().length() == 0) {
            printStream.println("DDR Interactive was not invoked with a command line pointing to a core file. Aborting command");
            return;
        }
        if (stringArray.length == 0) {
            this.showLibList(context, printStream);
            return;
        }
        if (stringArray.length >= 1) {
            boolean bl = false;
            if (stringArray[0].toLowerCase().equals("extract")) {
                File file = null;
                if (stringArray.length == 2) {
                    if (stringArray[1].equalsIgnoreCase("overwrite")) {
                        bl = true;
                    } else {
                        file = new File(stringArray[1]);
                        if (!file.exists()) {
                            printStream.println("The specified extraction directory does not exist. " + file.getAbsolutePath());
                            return;
                        }
                    }
                }
                this.extractLibs(context, printStream, file, bl);
                return;
            }
        }
        printStream.println("Command not recognised");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void extractLibs(Context context, PrintStream printStream, File file, boolean bl) {
        if (file == null) {
            boolean bl2;
            boolean bl3 = bl2 = !DDRInteractive.getPath().contains(File.separator);
            if (bl2) {
                FooterLibraryEntry[] footerLibraryEntryArray = System.getProperty("user.dir");
                file = new File((String)footerLibraryEntryArray);
            } else {
                file = new File(DDRInteractive.getPath());
                if (file.isFile()) {
                    file = file.getParentFile();
                }
            }
        }
        printStream.println("Extracting libraries to : " + file.getAbsolutePath());
        LibReader libReader = new LibReader();
        try {
            for (FooterLibraryEntry footerLibraryEntry : libReader.getEntries()) {
                File file2;
                if (footerLibraryEntry == null) continue;
                String string = footerLibraryEntry.getPath();
                if (string.charAt(0) == '/') {
                    string = string.substring(1);
                }
                if (File.separatorChar == '\\' && string.contains("/")) {
                    string.replace('/', '\\');
                }
                if ((file2 = new File(file, string).getCanonicalFile()).isFile()) {
                    if (file2.getParentFile() != null) {
                        file2.getParentFile().mkdirs();
                    }
                    if (file2.exists()) {
                        if (bl) {
                            printStream.println("Deleting existing library");
                            file2.delete();
                        } else {
                            printStream.println("Library " + file2.getPath() + " already exists on disk so skipping (to overwrite run !dclibs extract overwrite)");
                            continue;
                        }
                    }
                } else if (!file2.getParentFile().equals(file)) {
                    file2.getParentFile().mkdirs();
                }
                printStream.println("Extracting " + file2);
                libReader.extractLibrary(footerLibraryEntry.getPath(), file2);
            }
            return;
        }
        catch (IOException iOException) {
            printStream.println("Error extracting libraries : " + iOException.getMessage());
        }
    }

    private void getExeFromDDR(Context context, PrintStream printStream) {
        try {
            ICore iCore = context.process.getAddressSpace().getCore();
            if (ILibraryDependentCore.class.isAssignableFrom(iCore.getClass())) {
                ILibraryDependentCore iLibraryDependentCore = (ILibraryDependentCore)iCore;
                J9DDRImageProcess j9DDRImageProcess = new J9DDRImageProcess(context.process);
                ImageModule imageModule = j9DDRImageProcess.getExecutable();
                printStream.println("exe = " + imageModule.getName());
                iLibraryDependentCore.executablePathHint(imageModule.getName());
            }
        }
        catch (Exception exception) {
            printStream.println("Could not determine EXE name using DDR : " + exception.getMessage());
        }
    }

    private void showLibList(Context context, PrintStream printStream) {
        LibReader libReader = new LibReader();
        printStream.println("Showing library list for " + DDRInteractive.getPath());
        Collection<? extends IModule> collection = null;
        try {
            collection = context.process.getModules();
        }
        catch (CorruptDataException corruptDataException) {
            printStream.println("Corrupt data exception when retrieving list of libraries : " + corruptDataException.getMessage());
            return;
        }
        this.getExeFromDDR(context, printStream);
        for (IModule iModule : collection) {
            try {
                printStream.println("Lib : " + iModule.getName());
                FooterLibraryEntry footerLibraryEntry = libReader.getEntry(iModule.getName());
                if (footerLibraryEntry == null) {
                    printStream.println("\tLibrary is not appended to the core file, it may be present on the local disk");
                    continue;
                }
                printStream.println("\tLibrary has been collected");
                printStream.println("\tPath : " + footerLibraryEntry.getPath());
                printStream.println("\tName : " + footerLibraryEntry.getName());
                printStream.println("\tSize : " + footerLibraryEntry.getSize());
            }
            catch (CorruptDataException corruptDataException) {
                printStream.println("Library name is corrupt");
            }
        }
    }

    private class LibReader
    extends CoreFileResolver {
        public LibReader() {
            super(DDRInteractive.getPath());
        }

        public FooterLibraryEntry getEntry(String string) {
            if (this.footer == null) {
                return null;
            }
            return this.footer.findEntry(string);
        }

        public FooterLibraryEntry[] getEntries() {
            return this.footer.getEntries();
        }
    }
}

