/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader;

import com.ibm.jzos.ZFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.imageio.stream.ImageInputStreamImpl;

public class MVSFileReader
extends ImageInputStreamImpl {
    private ZFile dataset;
    private int recordLength;
    byte[] cacheRecord = null;
    private long cacheRecordNumber = -1L;
    private boolean firstTimeThrough = true;
    private List fposList = new ArrayList(10000);
    private static Logger log = Logger.getLogger("j9ddr.core_readers");

    public MVSFileReader(String string) throws FileNotFoundException {
        log.fine("Opening dump as an MVS dataset");
        try {
            this.dataset = new ZFile("//'" + string + "'", "rb,type=record");
            this.recordLength = this.dataset.getLrecl();
            this.cacheRecord = new byte[this.recordLength];
            log.fine("MVS dataset opened OK, record length = " + this.recordLength);
        }
        catch (IOException iOException) {
            FileNotFoundException fileNotFoundException = new FileNotFoundException("Could not find: " + string);
            fileNotFoundException.initCause(iOException);
            throw fileNotFoundException;
        }
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        long l = this.streamPos / (long)this.recordLength;
        int n3 = (int)(this.streamPos % (long)this.recordLength);
        if (l != this.cacheRecordNumber) {
            int n4;
            if (l != this.cacheRecordNumber + 1L) {
                this.dataset.setPos((byte[])this.fposList.get((int)l));
            }
            if (this.firstTimeThrough) {
                this.fposList.add(this.dataset.getPos());
            }
            if ((n4 = this.dataset.read(this.cacheRecord)) < 0) {
                this.firstTimeThrough = false;
                return -1;
            }
            this.cacheRecordNumber = l;
        }
        if (n3 + n2 > this.recordLength) {
            n2 = this.recordLength - n3;
        }
        System.arraycopy(this.cacheRecord, n3, byArray, n, n2);
        this.seek(this.streamPos + (long)n2);
        return n2;
    }

    @Override
    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray);
        return n < 0 ? -1 : byArray[1] & 0xFF;
    }

    @Override
    public void close() throws IOException {
        if (this.dataset != null) {
            this.dataset.close();
        }
        super.close();
    }
}

