/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.loops;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.util.Arrays;
import java.util.Comparator;
import sun.awt.SunHints;
import sun.java2d.SunGraphics2D;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.CustomComponent;
import sun.java2d.loops.GeneralRenderer;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.loops.GraphicsPrimitiveProxy;
import sun.java2d.loops.SurfaceType;
import sun.java2d.loops.XORComposite;

public final class GraphicsPrimitiveMgr {
    private static final boolean debugTrace = false;
    private static GraphicsPrimitive[] primitives;
    private static GraphicsPrimitive[] generalPrimitives;
    private static boolean needssort;
    private static Comparator primSorter;
    private static Comparator primFinder;

    private static native void initIDs(Class var0, Class var1, Class var2, Class var3, Class var4, Class var5, Class var6, Class var7, Class var8, Class var9, Class var10);

    private static native void registerNativeLoops();

    private GraphicsPrimitiveMgr() {
    }

    public static synchronized void register(GraphicsPrimitive[] graphicsPrimitiveArray) {
        GraphicsPrimitive[] graphicsPrimitiveArray2 = primitives;
        int n = 0;
        int n2 = graphicsPrimitiveArray.length;
        if (graphicsPrimitiveArray2 != null) {
            n = graphicsPrimitiveArray2.length;
        }
        GraphicsPrimitive[] graphicsPrimitiveArray3 = new GraphicsPrimitive[n + n2];
        if (graphicsPrimitiveArray2 != null) {
            System.arraycopy((Object)graphicsPrimitiveArray2, 0, (Object)graphicsPrimitiveArray3, 0, n);
        }
        System.arraycopy((Object)graphicsPrimitiveArray, 0, (Object)graphicsPrimitiveArray3, n, n2);
        needssort = true;
        primitives = graphicsPrimitiveArray3;
    }

    public static synchronized void registerGeneral(GraphicsPrimitive graphicsPrimitive) {
        if (generalPrimitives == null) {
            generalPrimitives = new GraphicsPrimitive[]{graphicsPrimitive};
            return;
        }
        int n = generalPrimitives.length;
        GraphicsPrimitive[] graphicsPrimitiveArray = new GraphicsPrimitive[n + 1];
        System.arraycopy((Object)generalPrimitives, 0, (Object)graphicsPrimitiveArray, 0, n);
        graphicsPrimitiveArray[n] = graphicsPrimitive;
        generalPrimitives = graphicsPrimitiveArray;
    }

    public static synchronized GraphicsPrimitive locate(int n, SurfaceType surfaceType) {
        return GraphicsPrimitiveMgr.locate(n, SurfaceType.OpaqueColor, CompositeType.Src, surfaceType);
    }

    public static synchronized GraphicsPrimitive locate(int n, SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        GraphicsPrimitive graphicsPrimitive = GraphicsPrimitiveMgr.locatePrim(n, surfaceType, compositeType, surfaceType2);
        if (graphicsPrimitive == null && (graphicsPrimitive = GraphicsPrimitiveMgr.locateGeneral(n)) != null && (graphicsPrimitive = graphicsPrimitive.makePrimitive(surfaceType, compositeType, surfaceType2)) != null && GraphicsPrimitive.traceflags != 0) {
            graphicsPrimitive = graphicsPrimitive.traceWrap();
        }
        return graphicsPrimitive;
    }

    public static synchronized GraphicsPrimitive locatePrim(int n, SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        PrimitiveSpec primitiveSpec = new PrimitiveSpec();
        for (SurfaceType surfaceType3 = surfaceType2; surfaceType3 != null; surfaceType3 = surfaceType3.getSuperType()) {
            for (SurfaceType surfaceType4 = surfaceType; surfaceType4 != null; surfaceType4 = surfaceType4.getSuperType()) {
                for (CompositeType compositeType2 = compositeType; compositeType2 != null; compositeType2 = compositeType2.getSuperType()) {
                    primitiveSpec.uniqueID = GraphicsPrimitive.makeUniqueID(n, surfaceType4, compositeType2, surfaceType3);
                    GraphicsPrimitive graphicsPrimitive = GraphicsPrimitiveMgr.locate(primitiveSpec);
                    if (graphicsPrimitive == null) continue;
                    return graphicsPrimitive;
                }
            }
        }
        return null;
    }

    private static GraphicsPrimitive locateGeneral(int n) {
        if (generalPrimitives == null) {
            return null;
        }
        for (int i = 0; i < generalPrimitives.length; ++i) {
            GraphicsPrimitive graphicsPrimitive = generalPrimitives[i];
            if (graphicsPrimitive.getPrimTypeID() != n) continue;
            return graphicsPrimitive;
        }
        return null;
    }

    private static GraphicsPrimitive locate(PrimitiveSpec primitiveSpec) {
        GraphicsPrimitive[] graphicsPrimitiveArray;
        if (needssort) {
            if (GraphicsPrimitive.traceflags != 0) {
                for (int i = 0; i < primitives.length; ++i) {
                    GraphicsPrimitiveMgr.primitives[i] = primitives[i].traceWrap();
                }
            }
            Arrays.sort(primitives, primSorter);
            needssort = false;
        }
        if ((graphicsPrimitiveArray = primitives) == null) {
            return null;
        }
        int n = Arrays.binarySearch(graphicsPrimitiveArray, primitiveSpec, primFinder);
        if (n >= 0) {
            GraphicsPrimitive graphicsPrimitive = graphicsPrimitiveArray[n];
            if (graphicsPrimitive instanceof GraphicsPrimitiveProxy) {
                graphicsPrimitiveArray[n] = graphicsPrimitive = ((GraphicsPrimitiveProxy)graphicsPrimitive).instantiate();
            }
            return graphicsPrimitive;
        }
        return null;
    }

    private static void writeLog(String string) {
    }

    public static void testPrimitiveInstantiation() {
        GraphicsPrimitiveMgr.testPrimitiveInstantiation(false);
    }

    public static void testPrimitiveInstantiation(boolean bl) {
        int n = 0;
        int n2 = 0;
        GraphicsPrimitive[] graphicsPrimitiveArray = primitives;
        for (int i = 0; i < graphicsPrimitiveArray.length; ++i) {
            GraphicsPrimitive graphicsPrimitive = graphicsPrimitiveArray[i];
            if (graphicsPrimitive instanceof GraphicsPrimitiveProxy) {
                GraphicsPrimitive graphicsPrimitive2 = ((GraphicsPrimitiveProxy)graphicsPrimitive).instantiate();
                if (!graphicsPrimitive2.getSignature().equals(graphicsPrimitive.getSignature()) || graphicsPrimitive2.getUniqueID() != graphicsPrimitive.getUniqueID()) {
                    System.out.println("r.getSignature == " + graphicsPrimitive2.getSignature());
                    System.out.println("r.getUniqueID == " + graphicsPrimitive2.getUniqueID());
                    System.out.println("p.getSignature == " + graphicsPrimitive.getSignature());
                    System.out.println("p.getUniqueID == " + graphicsPrimitive.getUniqueID());
                    throw new RuntimeException("Primitive " + graphicsPrimitive + " returns wrong signature for " + graphicsPrimitive2.getClass());
                }
                ++n2;
                graphicsPrimitive = graphicsPrimitive2;
                if (!bl) continue;
                System.out.println(graphicsPrimitive);
                continue;
            }
            if (bl) {
                System.out.println(graphicsPrimitive + " (not proxied).");
            }
            ++n;
        }
        System.out.println(n + " graphics primitives were not proxied.");
        System.out.println(n2 + " proxied graphics primitives resolved correctly.");
        System.out.println(n + n2 + " total graphics primitives");
    }

    public static void main(String[] stringArray) {
        if (needssort) {
            Arrays.sort(primitives, primSorter);
            needssort = false;
        }
        GraphicsPrimitiveMgr.testPrimitiveInstantiation(stringArray.length > 0);
    }

    static {
        needssort = true;
        GraphicsPrimitiveMgr.initIDs(GraphicsPrimitive.class, SurfaceType.class, CompositeType.class, SunGraphics2D.class, Color.class, AffineTransform.class, XORComposite.class, AlphaComposite.class, Path2D.class, Path2D.Float.class, SunHints.class);
        CustomComponent.register();
        GeneralRenderer.register();
        GraphicsPrimitiveMgr.registerNativeLoops();
        primSorter = new Comparator(){

            public int compare(Object object, Object object2) {
                int n;
                int n2 = ((GraphicsPrimitive)object).getUniqueID();
                return n2 == (n = ((GraphicsPrimitive)object2).getUniqueID()) ? 0 : (n2 < n ? -1 : 1);
            }
        };
        primFinder = new Comparator(){

            public int compare(Object object, Object object2) {
                int n;
                int n2 = ((GraphicsPrimitive)object).getUniqueID();
                return n2 == (n = ((PrimitiveSpec)object2).uniqueID) ? 0 : (n2 < n ? -1 : 1);
            }
        };
    }

    private static class PrimitiveSpec {
        public int uniqueID;

        private PrimitiveSpec() {
        }
    }
}

