/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import com.ibm.java.lang.management.internal.ManagementUtils;
import com.ibm.oti.util.Msg;
import javax.management.openmbean.CompositeData;

public class MemoryUsage {
    private long init;
    private long used;
    private long committed;
    private long max;
    private String TOSTRING_VALUE;

    public MemoryUsage(long l, long l2, long l3, long l4) {
        if (l < -1L) {
            throw new IllegalArgumentException(Msg.getString("K0608"));
        }
        if (l4 < -1L) {
            throw new IllegalArgumentException(Msg.getString("K0609"));
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException(Msg.getString("K060A"));
        }
        if (l3 < 0L) {
            throw new IllegalArgumentException(Msg.getString("K060B"));
        }
        if (l2 > l3) {
            throw new IllegalArgumentException(Msg.getString("K060C"));
        }
        if (l4 != -1L && l3 > l4) {
            throw new IllegalArgumentException(Msg.getString("K060D"));
        }
        this.init = l;
        this.used = l2;
        this.committed = l3;
        this.max = l4;
    }

    public long getCommitted() {
        return this.committed;
    }

    public long getInit() {
        return this.init;
    }

    public long getMax() {
        return this.max;
    }

    public long getUsed() {
        return this.used;
    }

    public String toString() {
        if (this.TOSTRING_VALUE == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("init = ");
            stringBuilder.append(this.init);
            MemoryUsage.appendSizeInKBytes(stringBuilder, this.init);
            stringBuilder.append("used = ");
            stringBuilder.append(this.used);
            MemoryUsage.appendSizeInKBytes(stringBuilder, this.used);
            stringBuilder.append("committed = ");
            stringBuilder.append(this.committed);
            MemoryUsage.appendSizeInKBytes(stringBuilder, this.committed);
            stringBuilder.append("max = ");
            stringBuilder.append(this.max);
            MemoryUsage.appendSizeInKBytes(stringBuilder, this.max);
            this.TOSTRING_VALUE = stringBuilder.toString().trim();
        }
        return this.TOSTRING_VALUE;
    }

    private static void appendSizeInKBytes(StringBuilder stringBuilder, long l) {
        if (l == -1L) {
            stringBuilder.append("(-1K) ");
        } else {
            stringBuilder.append("(").append(l / 1024L).append("K) ");
        }
    }

    public static MemoryUsage from(CompositeData compositeData) {
        MemoryUsage memoryUsage = null;
        if (compositeData != null) {
            ManagementUtils.verifyFieldNumber(compositeData, 4);
            String[] stringArray = new String[]{"init", "used", "committed", "max"};
            ManagementUtils.verifyFieldNames(compositeData, stringArray);
            String[] stringArray2 = new String[]{"java.lang.Long", "java.lang.Long", "java.lang.Long", "java.lang.Long"};
            ManagementUtils.verifyFieldTypes(compositeData, stringArray, stringArray2);
            Object[] objectArray = compositeData.getAll(stringArray);
            long l = (Long)objectArray[0];
            long l2 = (Long)objectArray[1];
            long l3 = (Long)objectArray[2];
            long l4 = (Long)objectArray[3];
            memoryUsage = new MemoryUsage(l, l2, l3, l4);
        }
        return memoryUsage;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof MemoryUsage)) {
            return false;
        }
        MemoryUsage memoryUsage = (MemoryUsage)object;
        if (memoryUsage.getInit() != this.getInit()) {
            return false;
        }
        if (memoryUsage.getCommitted() != this.getCommitted()) {
            return false;
        }
        if (memoryUsage.getUsed() != this.getUsed()) {
            return false;
        }
        return memoryUsage.getMax() == this.getMax();
    }

    public int hashCode() {
        return (Long.toString(this.getCommitted()) + this.getInit() + this.getMax() + this.getUsed()).hashCode();
    }
}

