/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import com.ibm.oti.util.Msg;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

final class MethodTypeHelper {
    static final Set<Class<?>> WRAPPER_SET;
    static final Class<?>[] primitivesArray;

    MethodTypeHelper() {
    }

    static Class<?> wrapPrimitive(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (Integer.TYPE == clazz) {
                return Integer.class;
            }
            if (Long.TYPE == clazz) {
                return Long.class;
            }
            if (Byte.TYPE == clazz) {
                return Byte.class;
            }
            if (Character.TYPE == clazz) {
                return Character.class;
            }
            if (Double.TYPE == clazz) {
                return Double.class;
            }
            if (Float.TYPE == clazz) {
                return Float.class;
            }
            if (Boolean.TYPE == clazz) {
                return Boolean.class;
            }
            if (Void.TYPE == clazz) {
                return Void.class;
            }
            if (Short.TYPE == clazz) {
                return Short.class;
            }
        }
        return clazz;
    }

    static Class<?> unwrapPrimitive(Class<?> clazz) {
        if (Integer.class == clazz) {
            return Integer.TYPE;
        }
        if (Long.class == clazz) {
            return Long.TYPE;
        }
        if (Byte.class == clazz) {
            return Byte.TYPE;
        }
        if (Character.class == clazz) {
            return Character.TYPE;
        }
        if (Double.class == clazz) {
            return Double.TYPE;
        }
        if (Float.class == clazz) {
            return Float.TYPE;
        }
        if (Short.class == clazz) {
            return Short.TYPE;
        }
        if (Boolean.class == clazz) {
            return Boolean.TYPE;
        }
        return clazz;
    }

    static String getBytecodeStringName(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return "I";
            }
            if (clazz == Long.TYPE) {
                return "J";
            }
            if (clazz == Byte.TYPE) {
                return "B";
            }
            if (clazz == Boolean.TYPE) {
                return "Z";
            }
            if (clazz == Void.TYPE) {
                return "V";
            }
            if (clazz == Character.TYPE) {
                return "C";
            }
            if (clazz == Double.TYPE) {
                return "D";
            }
            if (clazz == Float.TYPE) {
                return "F";
            }
            if (clazz == Short.TYPE) {
                return "S";
            }
        }
        Class<?> clazz2 = clazz;
        if (clazz.isArray()) {
            clazz2 = clazz.getComponentType();
            while (clazz2.isArray()) {
                clazz2 = clazz2.getComponentType();
            }
        }
        String string = clazz.getName().replace('.', '/');
        if (clazz.isArray()) {
            return string;
        }
        return "L" + string + ";";
    }

    private static final Class<?> nonPrimitiveClassFromString(String string, ClassLoader classLoader) {
        try {
            string = string.replace('/', '.');
            if (string.indexOf(76) == 0) {
                string = string.substring(1, string.length() - 1);
            }
            return Class.forName(string, false, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TypeNotPresentException(string, classNotFoundException);
        }
    }

    static final int parseIntoClass(char[] cArray, int n, ArrayList<Class<?>> arrayList, ClassLoader classLoader, String string) {
        Class<Object> clazz;
        char c = cArray[n];
        if (c == 'L' || c == '[') {
            String string2;
            int n2 = n;
            while (cArray[n] == '[') {
                ++n;
            }
            if (cArray[n] != 'L') {
                string2 = string.substring(n2, n + 1);
            } else {
                int n3 = string.indexOf(59, n);
                if (n3 == -1) {
                    throw new IllegalArgumentException(Msg.getString("K05d6", string));
                }
                string2 = string.substring(n2, n3 + 1);
                n = n3;
            }
            clazz = MethodTypeHelper.nonPrimitiveClassFromString(string2, classLoader);
        } else {
            try {
                clazz = primitivesArray[c - 65];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                clazz = null;
            }
            if (clazz == null) {
                if (c == 'V') {
                    MethodTypeHelper.primitivesArray[21] = Void.TYPE;
                    clazz = Void.TYPE;
                } else {
                    throw new IllegalArgumentException(Msg.getString("K05d7", c));
                }
            }
        }
        arrayList.add(clazz);
        return n;
    }

    static final MethodType vmResolveFromMethodDescriptorString(String string, ClassLoader classLoader, Class<?> clazz) throws Throwable {
        try {
            MethodType methodType = MethodType.fromMethodDescriptorString(string, classLoader);
            if (null != clazz) {
                methodType = methodType.appendParameterTypes(clazz);
            }
            return methodType;
        }
        catch (TypeNotPresentException typeNotPresentException) {
            Throwable throwable = typeNotPresentException.getCause();
            if (throwable instanceof ClassNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(throwable.getMessage());
                noClassDefFoundError.initCause(throwable);
                throw noClassDefFoundError;
            }
            throw typeNotPresentException;
        }
    }

    static {
        Class[] classArray = new Class[]{Byte.class, Character.class, Double.class, Float.class, Integer.class, Long.class, Short.class, Boolean.class};
        WRAPPER_SET = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(classArray)));
        primitivesArray = new Class[26];
        MethodTypeHelper.primitivesArray[1] = Byte.TYPE;
        MethodTypeHelper.primitivesArray[2] = Character.TYPE;
        MethodTypeHelper.primitivesArray[3] = Double.TYPE;
        MethodTypeHelper.primitivesArray[5] = Float.TYPE;
        MethodTypeHelper.primitivesArray[8] = Integer.TYPE;
        MethodTypeHelper.primitivesArray[9] = Long.TYPE;
        MethodTypeHelper.primitivesArray[18] = Short.TYPE;
        MethodTypeHelper.primitivesArray[25] = Boolean.TYPE;
    }
}

