/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.ConstantDoubleHandle;
import java.lang.invoke.ConstantFloatHandle;
import java.lang.invoke.ConstantIntHandle;
import java.lang.invoke.ConstantLongHandle;
import java.lang.invoke.ConstantObjectHandle;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleCache;
import java.lang.invoke.MethodType;
import java.lang.invoke.ThunkTable;

abstract class ConstantHandle
extends MethodHandle {
    private static final ThunkTable _thunkTable = new ThunkTable();
    private static final ConstantHandle constantHandleInt_0 = new ConstantIntHandle(MethodType.methodType(Integer.TYPE), 0);
    private static final ConstantHandle constantHandleInt_1 = new ConstantIntHandle(MethodType.methodType(Integer.TYPE), 1);
    private static final ConstantHandle constantHandleDouble_0 = new ConstantDoubleHandle(MethodType.methodType(Double.TYPE), 0.0);
    private static final ConstantHandle constantHandleDouble_1 = new ConstantDoubleHandle(MethodType.methodType(Double.TYPE), 1.0);
    private static final ConstantHandle constantHandleLong_0 = new ConstantLongHandle(MethodType.methodType(Long.TYPE), 0L);
    private static final ConstantHandle constantHandleLong_1 = new ConstantLongHandle(MethodType.methodType(Long.TYPE), 1L);

    ConstantHandle(MethodType methodType, byte by) {
        super(methodType, by, null);
    }

    ConstantHandle(ConstantHandle constantHandle, MethodType methodType) {
        super(constantHandle, methodType);
    }

    @Override
    protected final ThunkTable thunkTable() {
        return _thunkTable;
    }

    public static ConstantHandle get(Class<?> clazz, Object object) {
        MethodType methodType = MethodType.methodType(clazz);
        if (!clazz.isPrimitive()) {
            if (null != object) {
                return new ConstantObjectHandle(methodType, object);
            }
            MethodHandleCache methodHandleCache = MethodHandleCache.getCache(clazz);
            return (ConstantHandle)methodHandleCache.getNullConstantObjectHandle();
        }
        char c = '\u0000';
        if (object instanceof Character) {
            c = ((Character)object).charValue();
        }
        if (clazz == Double.TYPE) {
            double d = object instanceof Number ? ((Number)object).doubleValue() : (double)c;
            if (0.0 == d) {
                return constantHandleDouble_0;
            }
            if (1.0 == d) {
                return constantHandleDouble_1;
            }
            return new ConstantDoubleHandle(methodType, d);
        }
        if (clazz == Long.TYPE) {
            long l = object instanceof Number ? ((Number)object).longValue() : (long)c;
            if (0L == l) {
                return constantHandleLong_0;
            }
            if (1L == l) {
                return constantHandleLong_1;
            }
            return new ConstantLongHandle(methodType, l);
        }
        if (clazz == Float.TYPE) {
            float f = object instanceof Number ? ((Number)object).floatValue() : (float)c;
            return new ConstantFloatHandle(methodType, f);
        }
        int n = object instanceof Number ? ((Number)object).intValue() : (object instanceof Boolean ? ((Boolean)object != false ? 1 : 0) : (int)c);
        if (Integer.TYPE == clazz) {
            if (0 == n) {
                return constantHandleInt_0;
            }
            if (1 == n) {
                return constantHandleInt_1;
            }
        }
        return new ConstantIntHandle(methodType, n);
    }
}

