/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: vm_statistics
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class vm_statistics {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _active_countOffset_;
	public static final int _cow_faultsOffset_;
	public static final int _faultsOffset_;
	public static final int _free_countOffset_;
	public static final int _hitsOffset_;
	public static final int _inactive_countOffset_;
	public static final int _lookupsOffset_;
	public static final int _pageinsOffset_;
	public static final int _pageoutsOffset_;
	public static final int _purgeable_countOffset_;
	public static final int _purgesOffset_;
	public static final int _reactivationsOffset_;
	public static final int _speculative_countOffset_;
	public static final int _wire_countOffset_;
	public static final int _zero_fill_countOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_active_countOffset_ = 0;
		_cow_faultsOffset_ = 0;
		_faultsOffset_ = 0;
		_free_countOffset_ = 0;
		_hitsOffset_ = 0;
		_inactive_countOffset_ = 0;
		_lookupsOffset_ = 0;
		_pageinsOffset_ = 0;
		_pageoutsOffset_ = 0;
		_purgeable_countOffset_ = 0;
		_purgesOffset_ = 0;
		_reactivationsOffset_ = 0;
		_speculative_countOffset_ = 0;
		_wire_countOffset_ = 0;
		_zero_fill_countOffset_ = 0;
	}

}
