/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: jvmtiParamTypes
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class jvmtiParamTypes {

	// VM Constants

	public static final long SIZEOF;
	public static final long JVMTI_TYPE_CCHAR;
	public static final long JVMTI_TYPE_CVOID;
	public static final long JVMTI_TYPE_JBOOLEAN;
	public static final long JVMTI_TYPE_JBYTE;
	public static final long JVMTI_TYPE_JCHAR;
	public static final long JVMTI_TYPE_JCLASS;
	public static final long JVMTI_TYPE_JDOUBLE;
	public static final long JVMTI_TYPE_JFIELDID;
	public static final long JVMTI_TYPE_JFLOAT;
	public static final long JVMTI_TYPE_JINT;
	public static final long JVMTI_TYPE_JLONG;
	public static final long JVMTI_TYPE_JMETHODID;
	public static final long JVMTI_TYPE_JNIENV;
	public static final long JVMTI_TYPE_JOBJECT;
	public static final long JVMTI_TYPE_JSHORT;
	public static final long JVMTI_TYPE_JTHREAD;
	public static final long JVMTI_TYPE_JVALUE;
	public static final long jvmtiParamTypesEnsureWideEnum;


	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		JVMTI_TYPE_CCHAR = 0;
		JVMTI_TYPE_CVOID = 0;
		JVMTI_TYPE_JBOOLEAN = 0;
		JVMTI_TYPE_JBYTE = 0;
		JVMTI_TYPE_JCHAR = 0;
		JVMTI_TYPE_JCLASS = 0;
		JVMTI_TYPE_JDOUBLE = 0;
		JVMTI_TYPE_JFIELDID = 0;
		JVMTI_TYPE_JFLOAT = 0;
		JVMTI_TYPE_JINT = 0;
		JVMTI_TYPE_JLONG = 0;
		JVMTI_TYPE_JMETHODID = 0;
		JVMTI_TYPE_JNIENV = 0;
		JVMTI_TYPE_JOBJECT = 0;
		JVMTI_TYPE_JSHORT = 0;
		JVMTI_TYPE_JTHREAD = 0;
		JVMTI_TYPE_JVALUE = 0;
		jvmtiParamTypesEnsureWideEnum = 0;
	}

}
