/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: jvmtiHeapCallbacks
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class jvmtiHeapCallbacks {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _array_primitive_value_callbackOffset_;
	public static final int _heap_iteration_callbackOffset_;
	public static final int _heap_reference_callbackOffset_;
	public static final int _primitive_field_callbackOffset_;
	public static final int _reserved10Offset_;
	public static final int _reserved11Offset_;
	public static final int _reserved12Offset_;
	public static final int _reserved13Offset_;
	public static final int _reserved14Offset_;
	public static final int _reserved15Offset_;
	public static final int _reserved5Offset_;
	public static final int _reserved6Offset_;
	public static final int _reserved7Offset_;
	public static final int _reserved8Offset_;
	public static final int _reserved9Offset_;
	public static final int _string_primitive_value_callbackOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_array_primitive_value_callbackOffset_ = 0;
		_heap_iteration_callbackOffset_ = 0;
		_heap_reference_callbackOffset_ = 0;
		_primitive_field_callbackOffset_ = 0;
		_reserved10Offset_ = 0;
		_reserved11Offset_ = 0;
		_reserved12Offset_ = 0;
		_reserved13Offset_ = 0;
		_reserved14Offset_ = 0;
		_reserved15Offset_ = 0;
		_reserved5Offset_ = 0;
		_reserved6Offset_ = 0;
		_reserved7Offset_ = 0;
		_reserved8Offset_ = 0;
		_reserved9Offset_ = 0;
		_string_primitive_value_callbackOffset_ = 0;
	}

}
