/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: __darwin_x86_thread_state64
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class __darwin_x86_thread_state64 {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int ___csOffset_;
	public static final int ___fsOffset_;
	public static final int ___gsOffset_;
	public static final int ___r10Offset_;
	public static final int ___r11Offset_;
	public static final int ___r12Offset_;
	public static final int ___r13Offset_;
	public static final int ___r14Offset_;
	public static final int ___r15Offset_;
	public static final int ___r8Offset_;
	public static final int ___r9Offset_;
	public static final int ___raxOffset_;
	public static final int ___rbpOffset_;
	public static final int ___rbxOffset_;
	public static final int ___rcxOffset_;
	public static final int ___rdiOffset_;
	public static final int ___rdxOffset_;
	public static final int ___rflagsOffset_;
	public static final int ___ripOffset_;
	public static final int ___rsiOffset_;
	public static final int ___rspOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		___csOffset_ = 0;
		___fsOffset_ = 0;
		___gsOffset_ = 0;
		___r10Offset_ = 0;
		___r11Offset_ = 0;
		___r12Offset_ = 0;
		___r13Offset_ = 0;
		___r14Offset_ = 0;
		___r15Offset_ = 0;
		___r8Offset_ = 0;
		___r9Offset_ = 0;
		___raxOffset_ = 0;
		___rbpOffset_ = 0;
		___rbxOffset_ = 0;
		___rcxOffset_ = 0;
		___rdiOffset_ = 0;
		___rdxOffset_ = 0;
		___rflagsOffset_ = 0;
		___ripOffset_ = 0;
		___rsiOffset_ = 0;
		___rspOffset_ = 0;
	}

}
